/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * GLSymbol.java
 *
 * Created on 2006/07/19, 15:37
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package kldhandler;

import java.util.*;

/**
 *
 * @author naoyuki
 */
public class GLSymbol {
    private List<String> g1List;
    private List<String> g2List;
    
    private String g1l1 = null;
    private String g1l2 = null;
    private String g2l1 = null;
    private String g2l2 = null;

    String getG1L1() {
        return g1l1;
    }
    String getG1L2() {
        return g1l2;
    }
    String getG2L1() {
        return g2l1;
    }
    String getG2L2() {
        return g2l2;
    }
    
    public GLSymbol(String g1l1, String g1l2, String g2l1, String g2l2) {
        this.g1l1 = g1l1;
        this.g1l2 = g1l2;
        this.g2l1 = g2l1;
        this.g2l2 = g2l2;
    }
    
    public GLSymbol newSymWithOverride(GLSymbol addsym) {
        String a, b, c, d;
        String s = addsym.getG1L1();
        if (s != null) {
            a = s;
        } else {
            a = g1l1;
        }
        s = addsym.getG1L2();
        if (s != null) {
            b = s;
        }  else {
            b = g1l2;
        }
        s = addsym.getG2L1();
        if (s != null) {
            c = s;
        } else {
            c = g2l1;
        }
        s = addsym.getG2L2();
        if (s != null) {
            d = s;
        } else {
            d = g2l2;
        }
        return new GLSymbol(a, b, c, d);
    }
 
    public GLSymbol newSymWithoutOverride(GLSymbol addsym) {
        String a, b, c, d;
        String s = addsym.getG1L1();
        if (s != null && g1l1 == null) {
            a = s;
        } else {
            a = g1l1;
        }
        s = addsym.getG1L2();
        if (s != null && g1l2 == null) {
            b = s;
        }  else {
            b = g1l2;
        }
        s = addsym.getG2L1();
        if (s != null && g2l1 == null) {
            c = s;
        } else {
            c = g2l1;
        }
        s = addsym.getG2L2();
        if (s != null && g2l2 == null) {
            d = s;
        } else {
            d = g2l2;
        }
        return new GLSymbol(a, b, c, d);
    }
           
    // null replace
    private static String nr(String s) {
        if ((s == null) || s.toLowerCase().startsWith("nosymbol")) {
            return "---";
        }
        //System.err.println(s + " : " + s.length());        
        return s;
    }
    public String toString() {
        return nr(g1l1) + ", "  + nr(g1l2) + ", " + nr(g2l1) + ", " + nr(g2l2);
    }

    private void parseSymbolLine(String line) {
        // remove {, }
        int id1 = line.indexOf("{");
        int id2 = line.indexOf("}");
        if (id1 == -1 || id2 == -1) {
            // invalid format
            return;
        }
        line = line.substring(id1 + 1, id2).trim();
        String g1 = null;
        String g2 = null;
        
        if (line.startsWith("type") || line.startsWith("symbols")) {
            int idGroup1 = line.indexOf("symbols[Group1]");
            int idGroup2 = line.indexOf("symbols[Group2]");
            if (idGroup1 != -1) {
                int start = line.indexOf("[", idGroup1 + 15);
                int end = line.indexOf("]", idGroup1 + 15);
                if (start != -1 && end != -1) {
                    g1 = line.substring(start + 1, end);
                }
            }
            if (idGroup2 != -1) {
                int start = line.indexOf("[", idGroup2 + 15);
                int end = line.indexOf("]", idGroup2 + 15);
                if (start != -1 && end != -1) {
                    g2 = line.substring(start + 1, end);
                }
            }
        } else if (line.startsWith("[")) {
            int g1End = line.indexOf("]");
            if (g1End != -1) {
                g1 = line.substring(1, g1End);
                int g2Start = line.indexOf("[", g1End + 1);
                int g2End = line.indexOf("]", g1End + 1);
                if (g2Start != -1 && g2End != -1) {
                    g2 = line.substring(g2Start + 1, g2End);
                }
            }
        }
        String[] a1, a2;
        int i1 = 0, i2 = 0;
        int g1len = 0, g2len = 0;
        if (g1 != null) {
            a1 = g1.split(",");
            for (String name : a1) {
                g1List.add(name.trim());
            }
            g1len = g1List.size();
            if (g1len > 0) {
                String s = g1List.get(0);
                if (s.length() > 0) {
                    g1l1 = s;
                }
                if (g1len > 1) {
                    s = g1List.get(1);
                    if (s.length() > 0) {
                        g1l2 = s;
                    }
                }      
            }
        }
        if (g2 != null) {
            a2 = g2.split(",");
            for (String name : a2) {
                g2List.add(name.trim());
            }
            g2len = g2List.size();
            if (g2len > 0) {
                String s = g2List.get(0);
                if (s.length() > 0) {
                    g2l1 = s;
                }
                if (g2len > 1) {
                    s = g2List.get(1);
                    if (s.length() > 0) {
                        g2l2 = s;
                    }
                }     
            }
        }
        if (g2l1 == null && g1len > 2) {
            g2l1 = g1List.get(2);
            if (g2l2 == null && g1len > 3) {
                g2l2 = g1List.get(3);
            }
        }
    }
    
    public GLSymbol(String line) {
        g1List = new ArrayList<String>();
        g2List = new ArrayList<String>();

        parseSymbolLine(line); // setup g1List, g2Llist

        /*
        line = line.trim().substring(1, line.lastIndexOf("}")).trim();
        if (line.startsWith("[")) {
            int id1 = line.indexOf("[") + 1;
            int id2 = line.indexOf("]");
            if (id1 <= id2) {
                String g1 = line.substring(id1, id2).trim();
                int id3 = g1.indexOf(",");
                if (id3 != -1) {
                    g1l1 = g1.substring(0, id3).trim();
                    g1l2 = g1.substring(id3 + 1).trim();
                    int id4 = g1.indexOf(",", id3  + 1);
                    if (id4 != -1) {
                        // This seems 3 or 4 level definision
                        // Treat this as G1L3 -> G2L1, G1L4 -> G2L2
                        g1l2 = g1.substring(id3 + 1, id4).trim();
                        int id5 = g1.indexOf(",", id4 + 1);
                        if (id5 != -1) {
                            g2l1 = g1.substring(id4 + 1, id5).trim();
                            g2l2 = g1.substring(id5 + 1).trim();
                        } else {
                            g2l1 = g1.substring(id4 + 1);
                        }
                    }
                } else {
                    g1l1 = g1.trim();
                    if (g1l1.length() == 0) {
                        g1l1 = null;
                    }
                }
                int id4 = line.indexOf("[", id1 + 1) + 1;
                int id5 = line.indexOf("]", id2 + 1);
                if (id4 < id5) {
                    String g2 = line.substring(id4, id5).trim();
                    int id6 = g2.indexOf(",");
                    if (id6 != -1) {
                        g2l1 = g2.substring(0, id6).trim();
                        g2l2 = g2.substring(id6 + 1).trim();
                    } else {
                        g2l1 = g2.trim();
                        if (g2l1.length() == 0) {
                            g2l1 = null;
                        }
                    }
                }
            }
        } else if (line.startsWith("type") || line.startsWith("symbols[")) {
            int gi = line.indexOf("symbols[Group1]=");
            if (gi != -1) {
                gi += 16;
                int id1 = line.indexOf("[", gi) + 1;
                int id2 = line.indexOf("]", gi);
                if (id1 < id2) {
                    String g1 = line.substring(id1, id2).trim();
                    int id3 = g1.indexOf(",");
                    if (id3 != -1) {
                        g1l1 = g1.substring(0, id3).trim();
                        g1l2 = g1.substring(id3 + 1).trim();
                        int id4 = g1.indexOf(",", id3  + 1);
                        if (id4 != -1) {
                            // This seems 3 or 4 level definision
                            // Treat this as G1L3 -> G2L1, G1L4 -> G2L2
                            g1l2 = g1.substring(id3 + 1, id4).trim();
                            int id5 = g1.indexOf(",", id4 + 1);
                            if (id5 != -1) {
                                g2l1 = g1.substring(id4 + 1, id5).trim();
                                g2l2 = g1.substring(id5 + 1).trim();
                            } else {
                                g2l1 = g1.substring(id4 + 1);
                            }
                        }
                    } else {
                        g1l1 = g1.trim();
                    }
                }
            }
            int g2i = line.indexOf("symbols[Group2]=");
            if (g2i != -1) {
                g2i += 16;
                int id1 = line.indexOf("[", g2i) + 1;
                int id2 = line.indexOf("]", g2i);
                if (id1 < id2) {
                    String g2 = line.substring(id1, id2).trim();
                    int id3 = g2.indexOf(",");
                    if (id3 != -1) {
                        g2l1 = g2.substring(0, id3).trim();
                        g2l2 = g2.substring(id3 + 1).trim();
                        int id4 = g2.indexOf(",", id3  + 1);
                        if (id4 != -1) {
                            // This seems 3 or 4 level definision
                            // Ignore L3 or L4 in G2
                            g2l2 = g2.substring(id3 + 1, id4).trim();
                        }
                    } else {
                        g2l1 = g2.trim();
                    }
                }
            }
        }
         **/
    }
    
    /** Creates a new instance of GLSymbol */
    public GLSymbol() {
    }
    
}
