#include <iiimp.h>
#include <iiimp-opcode.h>


const int	iiimf_opcode_reply_table[128] = {
	IM_NOP,				/* 0 */

	IM_CONNECT_REPLY,		/* IM_CONNECT */
	IM_NOP,				/* IM_CONNECT_REPLY */
	IM_DISCONNECT_REPLY,		/* IM_DISCONNECT */
	IM_NOP,				/* IM_DISCONNECT_REPLY */
	IM_NOP,				/* IM_REGISTER_TRIGGER_KEYS */
	IM_TRIGGER_NOTIFY_REPLY,	/* IM_TRIGGER_NOTIFY */
	IM_NOP,				/* IM_TRIGGER_NOTIFY_REPLY */
	IM_SETIMVALUES_REPLY,		/* IM_SETIMVALUES */
	IM_NOP,				/* IM_SETIMVALUES_REPLY */
	IM_GETIMVALUES_REPLY,		/* IM_GETIMVALUES */
	IM_NOP,				/* IM_GETIMVALUES_REPLY */

	IM_FORWARD_EVENT_REPLY,		/* IM_FORWARD_EVENT */
	IM_NOP,				/* IM_FORWARD_EVENT_REPLY */
	IM_NOP,				/* IM_COMMIT_STRING */
	IM_FORWARD_EVENT_WITH_OPERATIONS_REPLY,
					/* IM_FORWARD_EVENT_WITH_OPERATIONS */
	IM_NOP,				/* IM_FORWARD_EVENT_WITH_OPERATIONS_REPLY */

	IM_NOP,				/* 17 */
	IM_NOP,				/* 18 */
	IM_NOP,				/* 19 */

	IM_CREATEIC_REPLY,		/* IM_CREATEIC */
	IM_NOP,				/* IM_CREATEIC_REPLY */
	IM_DESTROYIC_REPLY,		/* IM_DESTROYIC */
	IM_NOP,				/* IM_DESTROYIC_REPLY */
	IM_SETICVALUES_REPLY,		/* IM_SETICVALUES */
	IM_NOP,				/* IM_SETICVALUES_REPLY */
	IM_GETICVALUES_REPLY,		/* IM_GETICVALUES */
	IM_NOP,				/* IM_GETICVALUES_REPLY */
	IM_SETICFOCUS_REPLY,		/* IM_SETICFOCUS */
	IM_NOP,				/* IM_SETICFOCUS_REPLY */
	IM_UNSETICFOCUS_REPLY,		/* IM_UNSETICFOCUS */
	IM_NOP,				/* IM_UNSETICFOCUS_REPLY */
	IM_RESETIC_REPLY,		/* IM_RESETIC */
	IM_NOP,				/* IM_RESETIC_REPLY */

	IM_NOP,				/* 34 */
	IM_NOP,				/* 35 */
	IM_NOP,				/* 36 */
	IM_NOP,				/* 37 */
	IM_NOP,				/* 38 */
	IM_NOP,				/* 39 */

	IM_PREEDIT_START_REPLY,		/* IM_PREEDIT_START */
	IM_NOP,				/* IM_PREEDIT_START_REPLY */
	IM_PREEDIT_DRAW_REPLY,		/* IM_PREEDIT_DRAW */
	IM_NOP,				/* IM_PREEDIT_DRAW_REPLY */
	IM_NOP,				/* 44 */
	IM_NOP,				/* 45 */
	IM_PREEDIT_DONE_REPLY,		/* IM_PREEDIT_DONE */
	IM_NOP,				/* IM_PREEDIT_DONE_REPLY */

	IM_NOP,				/* 48 */
	IM_NOP,				/* 49 */

	IM_STATUS_START_REPLY,		/* IM_STATUS_START */
	IM_NOP,				/* IM_STATUS_START_REPLY */
	IM_STATUS_DRAW_REPLY,		/* IM_STATUS_DRAW */
	IM_NOP,				/* IM_STATUS_DRAW_REPLY */
	IM_STATUS_DONE_REPLY,		/* IM_STATUS_DONE */
	IM_NOP,				/* IM_STATUS_DONE_REPLY */

	IM_NOP,				/* 56 */
	IM_NOP,				/* 57 */
	IM_NOP,				/* 58 */
	IM_NOP,				/* 59 */
	IM_NOP,				/* 60 */
	IM_NOP,				/* 61 */
	IM_NOP,				/* 62 */
	IM_NOP,				/* 63 */
	IM_NOP,				/* 64 */
	IM_NOP,				/* 65 */
	IM_NOP,				/* 66 */
	IM_NOP,				/* 67 */
	IM_NOP,				/* 68 */
	IM_NOP,				/* 69 */

	IM_LOOKUP_CHOICE_START_REPLY,	/* IM_LOOKUP_CHOICE_START */
	IM_NOP,				/* IM_LOOKUP_CHOICE_START_REPLY */
	IM_LOOKUP_CHOICE_DRAW_REPLY,	/* IM_LOOKUP_CHOICE_DRAW */
	IM_NOP,				/* IM_LOOKUP_CHOICE_DRAW_REPLY */
	IM_LOOKUP_CHOICE_DONE_REPLY,	/* IM_LOOKUP_CHOICE_DONE */
	IM_NOP,				/* IM_LOOKUP_CHOICE_DONE_REPLY */
	IM_LOOKUP_CHOICE_PROCESS_REPLY,	/* IM_LOOKUP_CHOICE_PROCESS */
	IM_NOP,				/* IM_LOOKUP_CHOICE_PROCESS_REPLY */

	IM_NOP,				/* 78 */
	IM_NOP,				/* 79 */
	IM_NOP,				/* 80 */
	IM_NOP,				/* 81 */
	IM_NOP,				/* 82 */
	IM_NOP,				/* 83 */
	IM_NOP,				/* 84 */
	IM_NOP,				/* 85 */
	IM_NOP,				/* 86 */
	IM_NOP,				/* 87 */
	IM_NOP,				/* 88 */
	IM_NOP,				/* 89 */

	IM_AUX_START_REPLY,		/* IM_AUX_START */
	IM_NOP,				/* IM_AUX_START_REPLY */
	IM_AUX_DRAW_REPLY,		/* IM_AUX_DRAW */
	IM_NOP,				/* IM_AUX_DRAW_REPLY */
	IM_AUX_DONE_REPLY,		/* IM_AUX_DONE */
	IM_NOP,				/* IM_AUX_DONE_REPLY */
	IM_AUX_SETVALUES_REPLY,		/* IM_AUX_SETVALUES */
	IM_NOP,				/* IM_AUX_SETVALUES_REPLY */

	IM_AUX_GETVALUES_REPLY,		/* IM_AUX_GETVALUES */
	IM_NOP,				/* IM_AUX_GETVALUES_REPLY */
	IM_NOP,				/* 100 */
	IM_NOP,				/* 101 */
	IM_NOP,				/* 102 */
	IM_NOP,				/* 103 */
	IM_NOP,				/* 104 */
	IM_NOP,				/* 105 */
	IM_NOP,				/* 106 */
	IM_NOP,				/* 107 */
	IM_NOP,				/* 108 */
	IM_NOP,				/* 109 */
	IM_NOP,				/* 110 */
	IM_NOP,				/* 111 */
	IM_NOP,				/* 112 */
	IM_NOP,				/* 113 */
	IM_NOP,				/* 114 */
	IM_NOP,				/* 115 */
	IM_NOP,				/* 116 */
	IM_NOP,				/* 117 */
	IM_NOP,				/* 118 */
	IM_NOP,				/* 119 */
	IM_NOP,				/* 120 */
	IM_NOP,				/* 121 */
	IM_NOP,				/* 122 */
	IM_NOP,				/* 123 */
	IM_NOP,				/* 124 */
	IM_NOP,				/* 125 */
	IM_NOP,				/* 126 */
	IM_NOP,				/* 127 */
};


int
iiimf_opcode_reply(int opcode)
{
    return iiimf_opcode_reply_table[0x7f & opcode];
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
