#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#if defined(lint) && defined(HAVE_NOTE_H)
#include <note.h>
#endif /* lint && HAVE_NOTE_H */

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"
#include "print-misc.h"


IIIMP_message *
iiimp_lookup_choice_start_new(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    int			master,
    int			choice_per_window,
    int			rows,
    int			columns,
    int			direction,
    int			label_owner)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_LOOKUP_CHOICE_START;
    m->im_id = im_id;
    m->ic_id = ic_id;
    m->v.lookup_choice_start.master = master;
    m->v.lookup_choice_start.choice_per_window = choice_per_window;
    m->v.lookup_choice_start.rows = rows;
    m->v.lookup_choice_start.columns = columns;
    m->v.lookup_choice_start.direction = direction;
    m->v.lookup_choice_start.label_owner = label_owner;
    return m;
}


void
iiimp_lookup_choice_start_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(data_s))
#endif /* lint && HAVE_NOTE_H */
    if (NULL == m) return;
    free(m);
    return;
}


uchar_t *
iiimp_lookup_choice_start_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    int			master,
    int			choice_per_window,
    int			rows,
    int			columns,
    int			direction,
    int			label_owner,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;

    nbyte = 0;
    nbyte += 2;	/* input method id */
    nbyte += 2;	/* input context id */
    nbyte += 2;	/* which is master */
    nbyte += 2;	/* choice per window */
    nbyte += 2;	/* number of rows */
    nbyte += 2;	/* number of columns */
    nbyte += 2;	/* drawing up direction */
    nbyte += 2;	/* which owns label */

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_LOOKUP_CHOICE_START, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(ic_id, rest, p, data_s->byte_swap);
    PUTU16(master, rest, p, data_s->byte_swap);
    PUTU16(choice_per_window, rest, p, data_s->byte_swap);
    PUTU16(rows, rest, p, data_s->byte_swap);
    PUTU16(columns, rest, p, data_s->byte_swap);
    PUTU16(direction, rest, p, data_s->byte_swap);
    PUTU16(label_owner, rest, p, data_s->byte_swap);

    return buf;
}


IIIMP_message *
iiimp_lookup_choice_start_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *			m;
    IIIMP_lookup_choice_start_v *	v;
    size_t				rest;
    const uchar_t *			p;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 2 + 2 + 2 + 2 + 2 + 2)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.lookup_choice_start);

    m->opcode = opcode;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    GETU16(m->ic_id, rest, p, data_s->byte_swap);
    GETU16(v->master, rest, p, data_s->byte_swap);
    GETU16(v->choice_per_window, rest, p, data_s->byte_swap);
    GETU16(v->rows, rest, p, data_s->byte_swap);
    GETU16(v->columns, rest, p, data_s->byte_swap);
    GETU16(v->direction, rest, p, data_s->byte_swap);
    GETU16(v->label_owner, rest, p, data_s->byte_swap);

    *nbyte = rest;
    *ptr = p;

    return m;
}


void
iiimp_lookup_choice_start_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    IIIMP_lookup_choice_start_v *	v;

    v = &(m->v.lookup_choice_start);
    iiimp_message_header_print(data_s, m->opcode, m->im_id, m->ic_id);

    (void)fputc('\t', data_s->print_fp);

    (void)fprintf(data_s->print_fp, "%s ",
		  lookup_choice_master_string_get(v->master));
    (void)fprintf(data_s->print_fp, "choices_per_window=%d ",
		  v->choice_per_window);
    (void)fprintf(data_s->print_fp, "rows=%d ", v->rows);
    (void)fprintf(data_s->print_fp, "columns=%d\n", v->columns);
    (void)fputc('\t', data_s->print_fp);
    (void)fprintf(data_s->print_fp, "%s ",
		  lookup_choice_direction_string_get(v->direction));
    (void)fputc('\t', data_s->print_fp);
    (void)fprintf(data_s->print_fp, "%s",
		  lookup_choice_label_owner_string_get(v->label_owner));
    (void)fputc('\n', data_s->print_fp);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
