#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


#if !defined(USE_OBSOLETE_NS_CODE)
IIIMP_message *
iiimp_file_operation_new(
    IIIMP_data_s *			data_s,
    IIIMP_card16			im_id,
    IIIMP_file_operation_request *	request)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_FILE_OPERATION;
    m->im_id = im_id;
    m->ic_id = -1;
    m->v.file_operation.request = request;
    return m;
}


void
iiimp_file_operation_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    if (NULL == m) return;
    iiimp_file_operation_request_delete(data_s, m->v.file_operation.request);
    free(m);
    return;
}


uchar_t *
iiimp_file_operation_pack(
    IIIMP_data_s *			data_s,
    IIIMP_card16			im_id,
    IIIMP_file_operation_request *	request,
    size_t *				buf_size)
{
    size_t				nbyte;
    int					length;
    uchar_t *				buf;
    size_t				rest;
    uchar_t *				p;
    size_t				fop_list_nbyte;
    IIIMP_file_operation_request *	r;

    nbyte = 0;
    nbyte += 2;			/* input method id */
    nbyte += 2;			/* Pad(2) */
    for (fop_list_nbyte = 0, r = request; NULL != r; r = r->next) {
	fop_list_nbyte += r->nbyte;
    }
    nbyte += fop_list_nbyte;

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_FILE_OPERATION, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(0, rest, p, data_s->byte_swap);
    PUTU32(fop_list_nbyte, rest, p, data_s->byte_swap);
    iiimp_file_operation_request_pack(data_s, request, &rest, &p);

    return buf;
}


IIIMP_message *
iiimp_file_operation_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *		m;
    IIIMP_file_operation_v *	v;
    size_t			rest;
    const uchar_t *		p;
    int				len;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 4 + 4)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.file_operation);

    m->opcode = opcode;
    v->request = NULL;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    m->ic_id = -1;
    SKIP16(rest, p);

    GET32(len, rest, p, data_s->byte_swap);
    if ((len < 0) || (rest < len) || (0 != (len & 0x03))) {
	iiimp_file_operation_delete(data_s, m);
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    v->request = iiimp_file_operation_request_unpack(data_s, &rest, &p, len);
    if (NULL == v->request) {
	iiimp_file_operation_delete(data_s, m);
	return NULL;
    }

    *nbyte = rest;
    *ptr = p;

    return m;
}


void
iiimp_file_operation_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, -1);
    iiimp_file_operation_request_print(data_s, m->v.file_operation.request);
}


#else /* USE_OBSOLETE_NS_CODE */
IIIMP_message *
iiimp_file_operation_new(
    IIIMP_data_s *	        data_s,
    IIIMP_card16                im_id,
    IIIMP_card32                type,
    void *	        	value)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_FILE_OPERATION;
    m->im_id = im_id;
    m->ic_id = -1;
    m->v.file_operation.type = type;
    m->v.file_operation.value = value;
    return m;
}

void
iiimp_file_operation_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    if (NULL == m) return;

    switch (m->v.file_operation.type) {
      case IIIMP_FILE_OPERATION_TYPE_OPEN:
       iiimp_open_delete(data_s, (IIIMP_open *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_READ:
       iiimp_read_delete(data_s, (IIIMP_read *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_WRITE:
       iiimp_write_delete(data_s, (IIIMP_write *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CLOSE:
       iiimp_close_delete(data_s, (IIIMP_close *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_OPENDIR:
       iiimp_opendir_delete(data_s, (IIIMP_opendir *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CLOSEDIR:
       iiimp_closedir_delete(data_s, (IIIMP_closedir *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_SEEK:
       iiimp_seek_delete(data_s, (IIIMP_seek *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_MKDIR:
       iiimp_mkdir_delete(data_s, (IIIMP_mkdir *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_RMDIR:
       iiimp_rmdir_delete(data_s, (IIIMP_rmdir *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_SYMLINK:
       iiimp_symlink_delete(data_s, (IIIMP_symlink *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_STAT:
       iiimp_stat_delete(data_s, (IIIMP_stat *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_LSTAT:
       iiimp_lstat_delete(data_s, (IIIMP_lstat *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FSTAT:
       iiimp_fstat_delete(data_s, (IIIMP_fstat *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CREAT:
       iiimp_creat_delete(data_s, (IIIMP_creat *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_LSEEK:
       iiimp_lseek_delete(data_s, (IIIMP_lseek *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_UNLINK:
       iiimp_unlink_delete(data_s, (IIIMP_unlink *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_RENAME:
       iiimp_rename_delete(data_s, (IIIMP_rename *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FCNTL:
       iiimp_fcntl_delete(data_s, (IIIMP_fcntl *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_TRUNCATE:
       iiimp_truncate_delete(data_s, (IIIMP_truncate *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FTRUNCATE:
       iiimp_ftruncate_delete(data_s, (IIIMP_ftruncate *)m->v.file_operation.value);
       break;
    }
    free(m);
    return;
}

uchar_t *
iiimp_file_operation_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16        im_id,
    IIIMP_card32        type,
    void *      	value,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;

    nbyte = 0
	+ 2                 /* input method id */
	+ 2                 /* Pad(2) */
	+ 4 ;               /* file operation type */

    if (NULL != value) {
	switch (type) {
	  case IIIMP_FILE_OPERATION_TYPE_OPEN:
	   nbyte += ((IIIMP_open *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_READ:
	   nbyte += ((IIIMP_read *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_WRITE:
	   nbyte += ((IIIMP_write *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_CLOSE:
	   nbyte += ((IIIMP_close *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_OPENDIR:
	   nbyte += ((IIIMP_opendir *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_CLOSEDIR:
	   nbyte += ((IIIMP_closedir *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_SEEK:
	   nbyte += ((IIIMP_seek *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_MKDIR:
	   nbyte += ((IIIMP_mkdir *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_RMDIR:
	   nbyte += ((IIIMP_rmdir *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_SYMLINK:
	   nbyte += ((IIIMP_symlink *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_STAT:
	   nbyte += ((IIIMP_stat *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_LSTAT:
	   nbyte += ((IIIMP_lstat *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_FSTAT:
	   nbyte += ((IIIMP_fstat *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_CREAT:
	   nbyte += ((IIIMP_creat *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_LSEEK:
	   nbyte += ((IIIMP_lseek *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_UNLINK:
	   nbyte += ((IIIMP_unlink *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_RENAME:
	   nbyte += ((IIIMP_rename *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_FCNTL:
	   nbyte += ((IIIMP_fcntl *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_TRUNCATE:
	   nbyte += ((IIIMP_truncate *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_FTRUNCATE:
	   nbyte += ((IIIMP_ftruncate *)value)->nbyte;
	   break;
	}
    } 

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_FILE_OPERATION, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(0, rest, p, data_s->byte_swap);
    PUTU32(type, rest, p, data_s->byte_swap);

    if (NULL == value) {
	return NULL;
    } else {
	switch (type) {
	  case IIIMP_FILE_OPERATION_TYPE_OPEN:
	   iiimp_open_pack(data_s, (IIIMP_open *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_READ:
	   iiimp_read_pack(data_s, (IIIMP_read *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_WRITE:
	   iiimp_write_pack(data_s, (IIIMP_write *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_CLOSE:
	   iiimp_close_pack(data_s, (IIIMP_close *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_OPENDIR:
	   iiimp_opendir_pack(data_s, (IIIMP_opendir *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_CLOSEDIR:
	   iiimp_closedir_pack(data_s, (IIIMP_closedir *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_SEEK:
	   iiimp_seek_pack(data_s, (IIIMP_seek *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_MKDIR:
	   iiimp_mkdir_pack(data_s, (IIIMP_mkdir *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_RMDIR:
	   iiimp_rmdir_pack(data_s, (IIIMP_rmdir *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_SYMLINK:
	   iiimp_symlink_pack(data_s, (IIIMP_symlink *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_STAT:
	   iiimp_stat_pack(data_s, (IIIMP_stat *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_LSTAT:
	   iiimp_lstat_pack(data_s, (IIIMP_lstat *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_FSTAT:
	   iiimp_fstat_pack(data_s, (IIIMP_fstat *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_CREAT:
	   iiimp_creat_pack(data_s, (IIIMP_creat *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_LSEEK:
	   iiimp_lseek_pack(data_s, (IIIMP_lseek *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_UNLINK:
	   iiimp_unlink_pack(data_s, (IIIMP_unlink *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_RENAME:
	   iiimp_rename_pack(data_s, (IIIMP_rename *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_FCNTL:
	   iiimp_fcntl_pack(data_s, (IIIMP_fcntl *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_TRUNCATE:
	   iiimp_truncate_pack(data_s, (IIIMP_truncate *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_FTRUNCATE:
	   iiimp_ftruncate_pack(data_s, (IIIMP_ftruncate *)value, &rest, &p);
	   break;
        }
    }
    return buf;
}

IIIMP_message *
iiimp_file_operation_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *	       m;
    IIIMP_file_operation_v *   v;
    size_t		       rest;
    const uchar_t *	       p;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 4 + 4)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.file_operation);

    m->opcode = opcode;
    v->value = NULL;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    m->ic_id = -1;
    SKIP16(rest, p);
    GETU32(v->type, rest, p, data_s->byte_swap);

    switch (v->type) {
      case IIIMP_FILE_OPERATION_TYPE_OPEN:
       v->value = iiimp_open_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_READ:
       v->value = iiimp_read_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_WRITE:
       v->value = iiimp_write_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CLOSE:
       v->value = iiimp_close_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_OPENDIR:
       v->value = iiimp_opendir_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CLOSEDIR:
       v->value = iiimp_closedir_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_SEEK:
       v->value = iiimp_seek_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_MKDIR:
       v->value = iiimp_mkdir_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_RMDIR:
       v->value = iiimp_rmdir_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_SYMLINK:
       v->value = iiimp_symlink_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_STAT:
       v->value = iiimp_stat_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_LSTAT:
       v->value = iiimp_lstat_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FSTAT:
       v->value = iiimp_fstat_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CREAT:
       v->value = iiimp_creat_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_LSEEK:
       v->value = iiimp_lseek_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_UNLINK:
       v->value = iiimp_unlink_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_RENAME:
       v->value = iiimp_rename_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FCNTL:
       v->value = iiimp_fcntl_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_TRUNCATE:
       v->value = iiimp_truncate_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FTRUNCATE:
       v->value = iiimp_ftruncate_unpack(data_s, &rest, &p, rest);
       break;
    } 

    *nbyte = rest;
    *ptr = p;

    return m;
}

void
iiimp_file_operation_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, -1);
    (void)fprintf(data_s->print_fp, "\ttype = %d\n", m->v.file_operation.type);
    // (void)fprintf(data_s->print_fp, "\tnbyte = %d\n", m->v.file_operation.nbyte);
    (void)fputc('\n', data_s->print_fp);

    switch (m->v.file_operation.type) {
      case IIIMP_FILE_OPERATION_TYPE_OPEN:
       iiimp_open_print(data_s, (IIIMP_open *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_READ:
       iiimp_read_print(data_s, (IIIMP_read *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_WRITE:
       iiimp_write_print(data_s, (IIIMP_write *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CLOSE:
       iiimp_close_print(data_s, (IIIMP_close *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_OPENDIR:
       iiimp_opendir_print(data_s, (IIIMP_opendir *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CLOSEDIR:
       iiimp_closedir_print(data_s, (IIIMP_closedir *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_SEEK:
       iiimp_seek_print(data_s, (IIIMP_seek *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_MKDIR:
       iiimp_mkdir_print(data_s, (IIIMP_mkdir *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_RMDIR:
       iiimp_rmdir_print(data_s, (IIIMP_rmdir *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_SYMLINK:
       iiimp_symlink_print(data_s, (IIIMP_symlink *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_STAT:
       iiimp_stat_print(data_s, (IIIMP_stat *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_LSTAT:
       iiimp_lstat_print(data_s, (IIIMP_lstat *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FSTAT:
       iiimp_fstat_print(data_s, (IIIMP_fstat *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CREAT:
       iiimp_creat_print(data_s, (IIIMP_creat *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_LSEEK:
       iiimp_lseek_print(data_s, (IIIMP_lseek *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_UNLINK:
       iiimp_unlink_print(data_s, (IIIMP_unlink *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_RENAME:
       iiimp_rename_print(data_s, (IIIMP_rename *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FCNTL:
       iiimp_fcntl_print(data_s, (IIIMP_fcntl *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_TRUNCATE:
       iiimp_truncate_print(data_s, (IIIMP_truncate *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FTRUNCATE:
       iiimp_ftruncate_print(data_s, (IIIMP_ftruncate *)m->v.file_operation.value);
       break;
    } 
}
#endif /* USE_OBSOLETE_NS_CODE */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
