#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


#if !defined(USE_OBSOLETE_NS_CODE)
IIIMP_message *
iiimp_file_operation_reply_new(
    IIIMP_data_s *			data_s,
    IIIMP_card16			im_id,
    IIIMP_file_operation_result *	result)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_FILE_OPERATION_REPLY;
    m->im_id = im_id;
    m->ic_id = -1;
    m->v.file_operation_reply.result = result;
    return m;
}


void
iiimp_file_operation_reply_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    if (NULL == m) return;
    iiimp_file_operation_result_delete(data_s,
				       m->v.file_operation_reply.result);
    free(m);
    return;
}


uchar_t *
iiimp_file_operation_reply_pack(
    IIIMP_data_s *			data_s,
    IIIMP_card16			im_id,
    IIIMP_file_operation_result *	result,
    size_t *				buf_size)
{
    size_t				nbyte;
    int					length;
    uchar_t *				buf;
    size_t				rest;
    uchar_t *				p;
    size_t				fop_list_nbyte;
    IIIMP_file_operation_result *	r;

    nbyte = 0;
    nbyte += 2;			/* input method id */
    nbyte += 2;			/* Pad(2) */
    for (fop_list_nbyte = 0, r = result; NULL != r; r = r->next) {
	fop_list_nbyte += r->nbyte;
    }
    nbyte += fop_list_nbyte;

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_FILE_OPERATION_REPLY, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(0, rest, p, data_s->byte_swap);
    PUTU32(fop_list_nbyte, rest, p, data_s->byte_swap);
    iiimp_file_operation_result_pack(data_s, result, &rest, &p);

    return buf;
}


IIIMP_message *
iiimp_file_operation_reply_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *			m;
    IIIMP_file_operation_reply_v *	v;
    size_t				rest;
    const uchar_t *			p;
    int					len;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 4 + 4)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.file_operation_reply);

    m->opcode = opcode;
    v->result = NULL;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    m->ic_id = -1;
    SKIP16(rest, p);

    GET32(len, rest, p, data_s->byte_swap);
    if ((len < 0) || (rest < len) || (0 != (len & 0x03))) {
	iiimp_file_operation_reply_delete(data_s, m);
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    v->result = iiimp_file_operation_result_unpack(data_s, &rest, &p, len);
    if (NULL == v->result) {
	iiimp_file_operation_reply_delete(data_s, m);
	return NULL;
    }

    *nbyte = rest;
    *ptr = p;

    return m;
}


void
iiimp_file_operation_reply_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, -1);
    iiimp_file_operation_result_print(data_s, m->v.file_operation_reply.result);
}


#else /* USE_OBSOLETE_NS_CODE */
IIIMP_message *
iiimp_file_operation_reply_new(
    IIIMP_data_s *	        data_s,
    IIIMP_card16                im_id,
    IIIMP_card32                type,
    void *	        	value)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_FILE_OPERATION_REPLY;
    m->im_id = im_id;
    m->ic_id = -1;
    m->v.file_operation_reply.type = type;
    m->v.file_operation_reply.value = value;
    return m;
}

void
iiimp_file_operation_reply_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    if (NULL == m) return;

    switch (m->v.file_operation_reply.type) {
      case IIIMP_FILE_OPERATION_TYPE_OPEN_REPLY:
       iiimp_open_reply_delete(data_s, (IIIMP_open_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_READ_REPLY:
       iiimp_read_reply_delete(data_s, (IIIMP_read_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_WRITE_REPLY:
       iiimp_write_reply_delete(data_s, (IIIMP_write_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CLOSE_REPLY:
       iiimp_close_reply_delete(data_s, (IIIMP_close_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_OPENDIR_REPLY:
       iiimp_opendir_reply_delete(data_s, (IIIMP_opendir_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CLOSEDIR_REPLY:
       iiimp_closedir_reply_delete(data_s, (IIIMP_closedir_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_SEEK_REPLY:
       iiimp_seek_reply_delete(data_s, (IIIMP_seek_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_MKDIR_REPLY:
       iiimp_mkdir_reply_delete(data_s, (IIIMP_mkdir_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_RMDIR_REPLY:
       iiimp_rmdir_reply_delete(data_s, (IIIMP_rmdir_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_SYMLINK_REPLY:
       iiimp_symlink_reply_delete(data_s, (IIIMP_symlink_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_STAT_REPLY:
       iiimp_stat_reply_delete(data_s, (IIIMP_stat_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_LSTAT_REPLY:
       iiimp_lstat_reply_delete(data_s, (IIIMP_lstat_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FSTAT_REPLY:
       iiimp_fstat_reply_delete(data_s, (IIIMP_fstat_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CREAT_REPLY:
       iiimp_creat_reply_delete(data_s, (IIIMP_creat_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_LSEEK_REPLY:
       iiimp_lseek_reply_delete(data_s, (IIIMP_lseek_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_UNLINK_REPLY:
       iiimp_unlink_reply_delete(data_s, (IIIMP_unlink_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_RENAME_REPLY:
       iiimp_rename_reply_delete(data_s, (IIIMP_rename_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FCNTL_REPLY:
       iiimp_fcntl_reply_delete(data_s, (IIIMP_fcntl_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_TRUNCATE_REPLY:
       iiimp_truncate_reply_delete(data_s, (IIIMP_truncate_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FTRUNCATE_REPLY:
       iiimp_ftruncate_reply_delete(data_s, (IIIMP_ftruncate_reply *)m->v.file_operation_reply.value);
       break;
    }
    free(m);
    return;
}

uchar_t *
iiimp_file_operation_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16        im_id,
    IIIMP_card32        type,
    void *      	value,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;

    nbyte = 0
	+ 2                 /* input method id */
	+ 2                 /* Pad(2) */
	+ 4 ;               /* file operation type */

    if (NULL != value) {
	switch (type) {
	  case IIIMP_FILE_OPERATION_TYPE_OPEN_REPLY:
	   nbyte += ((IIIMP_open_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_READ_REPLY:
	   nbyte += ((IIIMP_read_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_WRITE_REPLY:
	   nbyte += ((IIIMP_write_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_CLOSE_REPLY:
	   nbyte += ((IIIMP_close_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_OPENDIR_REPLY:
	   nbyte += ((IIIMP_opendir_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_CLOSEDIR_REPLY:
	   nbyte += ((IIIMP_closedir_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_SEEK_REPLY:
	   nbyte += ((IIIMP_seek_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_MKDIR_REPLY:
	   nbyte += ((IIIMP_mkdir_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_RMDIR_REPLY:
	   nbyte += ((IIIMP_rmdir_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_SYMLINK_REPLY:
	   nbyte += ((IIIMP_symlink_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_STAT_REPLY:
	   nbyte += ((IIIMP_stat_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_LSTAT_REPLY:
	   nbyte += ((IIIMP_lstat_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_FSTAT_REPLY:
	   nbyte += ((IIIMP_fstat_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_CREAT_REPLY:
	   nbyte += ((IIIMP_creat_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_LSEEK_REPLY:
	   nbyte += ((IIIMP_lseek_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_UNLINK_REPLY:
	   nbyte += ((IIIMP_unlink_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_RENAME_REPLY:
	   nbyte += ((IIIMP_rename_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_FCNTL_REPLY:
	   nbyte += ((IIIMP_fcntl_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_TRUNCATE_REPLY:
	   nbyte += ((IIIMP_truncate_reply *)value)->nbyte;
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_FTRUNCATE_REPLY:
	   nbyte += ((IIIMP_ftruncate_reply *)value)->nbyte;
	   break;
	}
    }

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_FILE_OPERATION_REPLY, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(0, rest, p, data_s->byte_swap);
    PUTU32(type, rest, p, data_s->byte_swap);

    if (NULL == value) {
	return NULL;
    } else {
	switch (type) {
	  case IIIMP_FILE_OPERATION_TYPE_OPEN_REPLY:
	   iiimp_open_reply_pack(data_s, (IIIMP_open_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_READ_REPLY:
	   iiimp_read_reply_pack(data_s, (IIIMP_read_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_WRITE_REPLY:
	   iiimp_write_reply_pack(data_s, (IIIMP_write_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_CLOSE_REPLY:
	   iiimp_close_reply_pack(data_s, (IIIMP_close_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_OPENDIR_REPLY:
	   iiimp_opendir_reply_pack(data_s, (IIIMP_opendir_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_CLOSEDIR_REPLY:
	   iiimp_closedir_reply_pack(data_s, (IIIMP_closedir_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_SEEK_REPLY:
	   iiimp_seek_reply_pack(data_s, (IIIMP_seek_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_MKDIR_REPLY:
	   iiimp_mkdir_reply_pack(data_s, (IIIMP_mkdir_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_RMDIR_REPLY:
	   iiimp_rmdir_reply_pack(data_s, (IIIMP_rmdir_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_SYMLINK_REPLY:
	   iiimp_symlink_reply_pack(data_s, (IIIMP_symlink_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_STAT_REPLY:
	   iiimp_stat_reply_pack(data_s, (IIIMP_stat_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_LSTAT_REPLY:
	   iiimp_lstat_reply_pack(data_s, (IIIMP_lstat_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_FSTAT_REPLY:
	   iiimp_fstat_reply_pack(data_s, (IIIMP_fstat_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_CREAT_REPLY:
	   iiimp_creat_reply_pack(data_s, (IIIMP_creat_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_LSEEK_REPLY:
	   iiimp_lseek_reply_pack(data_s, (IIIMP_lseek_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_UNLINK_REPLY:
	   iiimp_unlink_reply_pack(data_s, (IIIMP_unlink_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_RENAME_REPLY:
	   iiimp_rename_reply_pack(data_s, (IIIMP_rename_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_FCNTL_REPLY:
	   iiimp_fcntl_reply_pack(data_s, (IIIMP_fcntl_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_TRUNCATE_REPLY:
	   iiimp_truncate_reply_pack(data_s, (IIIMP_truncate_reply *)value, &rest, &p);
	   break;
	  case IIIMP_FILE_OPERATION_TYPE_FTRUNCATE_REPLY:
	   iiimp_ftruncate_reply_pack(data_s, (IIIMP_ftruncate_reply *)value, &rest, &p);
	   break;
	}
    }

    return buf;
}

IIIMP_message *
iiimp_file_operation_reply_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *	             m;
    IIIMP_file_operation_reply_v *   v;
    size_t		             rest;
    const uchar_t *	             p;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 4)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.file_operation_reply);

    m->opcode = opcode;
    v->value = NULL;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    m->ic_id = -1;
    SKIP16(rest, p);
    GETU32(v->type, rest, p, data_s->byte_swap);

    switch (v->type) {
      case IIIMP_FILE_OPERATION_TYPE_OPEN_REPLY:
       v->value = iiimp_open_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_READ_REPLY:
       v->value = iiimp_read_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_WRITE_REPLY:
       v->value = iiimp_write_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CLOSE_REPLY:
       v->value = iiimp_close_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_OPENDIR_REPLY:
       v->value = iiimp_opendir_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CLOSEDIR_REPLY:
       v->value = iiimp_closedir_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_SEEK_REPLY:
       v->value = iiimp_seek_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_MKDIR_REPLY:
       v->value = iiimp_mkdir_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_RMDIR_REPLY:
       v->value = iiimp_rmdir_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_SYMLINK_REPLY:
       v->value = iiimp_symlink_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_STAT_REPLY:
       v->value = iiimp_stat_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_LSTAT_REPLY:
       v->value = iiimp_lstat_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FSTAT_REPLY:
       v->value = iiimp_fstat_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CREAT_REPLY:
       v->value = iiimp_creat_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_LSEEK_REPLY:
       v->value = iiimp_lseek_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_UNLINK_REPLY:
       v->value = iiimp_unlink_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_RENAME_REPLY:
       v->value = iiimp_rename_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FCNTL_REPLY:
       v->value = iiimp_fcntl_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_TRUNCATE_REPLY:
       v->value = iiimp_truncate_reply_unpack(data_s, &rest, &p, rest);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FTRUNCATE_REPLY:
       v->value = iiimp_ftruncate_reply_unpack(data_s, &rest, &p, rest);
       break;
    } 

    *nbyte = rest;
    *ptr = p;

    return m;
}

void
iiimp_file_operation_reply_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, -1);
    (void)fprintf(data_s->print_fp, "\ttype = %d\n", m->v.file_operation_reply.type);
    (void)fputc('\n', data_s->print_fp);

    switch (m->v.file_operation_reply.type) {
      case IIIMP_FILE_OPERATION_TYPE_OPEN_REPLY:
       iiimp_open_reply_print(data_s, (IIIMP_open_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_READ_REPLY:
       iiimp_read_reply_print(data_s, (IIIMP_read_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_WRITE_REPLY:
       iiimp_write_reply_print(data_s, (IIIMP_write_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CLOSE_REPLY:
       iiimp_close_reply_print(data_s, (IIIMP_close_reply *)m->v.file_operation_reply.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_OPENDIR_REPLY:
       iiimp_opendir_reply_print(data_s, (IIIMP_opendir_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CLOSEDIR_REPLY:
       iiimp_closedir_reply_print(data_s, (IIIMP_closedir_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_SEEK_REPLY:
       iiimp_seek_reply_print(data_s, (IIIMP_seek_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_MKDIR_REPLY:
       iiimp_mkdir_reply_print(data_s, (IIIMP_mkdir_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_RMDIR_REPLY:
       iiimp_rmdir_reply_print(data_s, (IIIMP_rmdir_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_SYMLINK_REPLY:
       iiimp_symlink_reply_print(data_s, (IIIMP_symlink_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_STAT_REPLY:
       iiimp_stat_reply_print(data_s, (IIIMP_stat_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_LSTAT_REPLY:
       iiimp_lstat_reply_print(data_s, (IIIMP_lstat_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FSTAT_REPLY:
       iiimp_fstat_reply_print(data_s, (IIIMP_fstat_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_CREAT_REPLY:
       iiimp_creat_reply_print(data_s, (IIIMP_creat_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_LSEEK_REPLY:
       iiimp_lseek_reply_print(data_s, (IIIMP_lseek_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_UNLINK_REPLY:
       iiimp_unlink_reply_print(data_s, (IIIMP_unlink_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_RENAME_REPLY:
       iiimp_rename_reply_print(data_s, (IIIMP_rename_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FCNTL_REPLY:
       iiimp_fcntl_reply_print(data_s, (IIIMP_fcntl_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_TRUNCATE_REPLY:
       iiimp_truncate_reply_print(data_s, (IIIMP_truncate_reply *)m->v.file_operation.value);
       break;
      case IIIMP_FILE_OPERATION_TYPE_FTRUNCATE_REPLY:
       iiimp_ftruncate_reply_print(data_s, (IIIMP_ftruncate_reply *)m->v.file_operation.value);
       break;
    } 
}
#endif /* USE_OBSOLETE_NS_CODE */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
