/*
  Copyright 2002-2003 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <string.h>

#include "codetable.h"
#include "unit_input.h"
#include "SunIM.h"
#include "logf.h"

#define LOOKUP_CHOICE_NUM   7

#define IME_Status  ime_buffer->return_status
#define Input_Buf  ime_buffer->inputkey_buf
#define Input_Len  ime_buffer->inputkey_len
#define Preedit_Buf  ime_buffer->preedit_buf
#define Preedit_Len  ime_buffer->preedit_len
#define Preedit_CaretPos ime_buffer->preedit_caretpos
#define Commit_Buf  ime_buffer->commit_buf
#define Commit_Len  ime_buffer->commit_len
#define Status_Buf  ime_buffer->status_buf
#define Status_Len  ime_buffer->status_len
#define Lookup_Buf  ime_buffer->lookup_buf
#define Lookup_Num  ime_buffer->lookup_num
#define Lookup_Pos  ime_buffer->cur_lookup_pos
#define Candidates_Buf  ime_buffer->candidates_buf
#define Additions_Buf  ime_buffer->additions_buf
#define DeadKey_Flag  ime_buffer->hotkey_flag

int Is_UsedCodes_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  if ( key > 0xff )
    return (0);

  if ( index(hztbl->UsedCodes, key) )
    return(1);

  return(0);
}

int get_select_num(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  int ret = -1;
  switch(hztbl->nSelectKeyMode)
    {
    case NUMBER_MODE:
      if (key >= '0' && key <= '9')
	ret = (key - '0' + 9) % 10;
      break;

    case LOWER_MODE:
      if (key >= 'a' && key <= 'a' + 10)
	ret = key - 'a';
      break;

    case UPPER_MODE:
      if (key >= 'A' && key <= 'A' + 10)
	ret = key - 'A';
      break;
    }
  return(ret);
}

int Is_Select_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  int ret = get_select_num(hztbl, key);
  if (ret == -1)
    return(0);
  else
    return(1);
}

int Is_Commit_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  if (key == SPACE_KEY || key == RETURN_KEY)
    return(1);
  else
    return(0);
}

int Is_BackSpace_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  unsigned char *keylist = hztbl->functionkey[BACKSPACE_KEY_ID].keylist;

  if (key > 0xff || key == 0)
    return (0);

  if (key == BACKSPACE_KEY || key == DELETE_KEY)
    return(1);

  if ( keylist[0] )
    {
      if ( index(keylist, key) )
	return(1);
    }

  return(0);
}

int Is_ClearAll_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  unsigned char *keylist = hztbl->functionkey[CLEARALL_KEY_ID].keylist;

  if (key > 0xff || key == 0)
    return (0);

  if (key == ESC_KEY)
    return(1);

  if ( keylist[0] )
    {
      if ( index(keylist, key) )
	return(1);
    }
  return(0);
}

int Is_NextPage_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  unsigned char *keylist = hztbl->functionkey[PAGEDOWN_KEY_ID].keylist;

  if (key > 0xff)
    return (0);

  if (key == PAGEDOWN_KEY)
    return(1);

  if ( keylist[0] )
    {
      if ( index(keylist, key) )
	return(1);
    }
  return(0);
}

int Is_PrevPage_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  unsigned char *keylist = hztbl->functionkey[PAGEUP_KEY_ID].keylist;

  if (key > 0xff)
    return (0);

  if (key == PAGEUP_KEY)
    return(1);
 
  if ( keylist[0] )
    {
      if ( index(keylist, key) )
	return(1);
    }
  return(0);
}

int get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, pos, max_lookup_num, is_leaf)
     CodeTableStruct *hztbl;
     IMEBufferRec *ime_buffer;
     int nHelpInfoMode;
     int pos;
     int max_lookup_num;
     int *is_leaf;
{
  int i, lookup_num;

  log_f("get_lookup_result : Input_Len[%d]\n",Input_Len);
  lookup_num = codetable_search(hztbl, Input_Buf, Input_Len, Candidates_Buf, Additions_Buf, pos, max_lookup_num, is_leaf); 
  if (lookup_num > 0)
    {
      for (i=0; i<lookup_num; i++)
	{
	  log_f("%d: %s %s\n", i, Candidates_Buf[i], Additions_Buf[i]);
	  if (nHelpInfoMode)
	    sprintf((char *)Lookup_Buf[i], "%s %s", Candidates_Buf[i], Additions_Buf[i]);
	  else
	    strcpy(Lookup_Buf[i], Candidates_Buf[i]);
	}
    }
  return(lookup_num);
}

static inline int 
clean_all_area(IMEBufferRec *ime_buffer)
{
  Input_Len = 0;
  Input_Buf[Input_Len] = 0;
  Preedit_Len = 0;
  Lookup_Num = 0;
  Preedit_CaretPos = 0;
  IME_Status = IME_PREEDIT_AREA | IME_LOOKUP_AREA;
}

static inline int 
commit_and_clean_all_area(IMEBufferRec *ime_buffer)
{
  clean_all_area (ime_buffer);
  IME_Status |= IME_COMMIT;

  if (DeadKey_Flag == IME_HOTKEY_START)
    DeadKey_Flag = IME_HOTKEY_END;
}

static int 
commit_candidate (ime_buffer, id)
     IMEBufferRec *ime_buffer;
     int id;
{
  if (id >= Lookup_Num)
    return(-1);
 
  strcpy((char *)Commit_Buf, (char *)Candidates_Buf[id]);
  Commit_Len = strlen((char *)Commit_Buf);
  log_f("Inside commit_candidate, Commit_Buf <%s>\n",Commit_Buf);

  commit_and_clean_all_area (ime_buffer);
  return(0);
}

static int 
commit_char (ime_buffer, key)
     IMEBufferRec *ime_buffer;
     int key;
{
  Commit_Len = 0;
  Commit_Buf[Commit_Len++] = key;
  Commit_Buf[Commit_Len] = '\0';

  commit_and_clean_all_area (ime_buffer);
  return(0);
}


void warning_bell()
{
}

/* return value:  IME_NOT_USED_KEY:  if IME not use this key, return this key to systerm directly */
/*                IME_USED_KEY:      if IME has used this key */
int codetable_filter(hztbl, key_event, ime_buffer)
     CodeTableStruct *hztbl;
     IMEKey key_event;
     IMEBufferRec *ime_buffer;
{
  int  keychar;
  int  Max_Lookup_Num = LOOKUP_CHOICE_NUM;
  int  nKeyByKeyMode = hztbl->nKeyByKeyMode;
  int  nHelpInfoMode = hztbl->nHelpInfoMode;
  int  nAutoSelectMode = hztbl->nAutoSelectMode;
  int  nKeyPromptMode = hztbl->nKeyPromptMode;
 
  ime_buffer->encode = hztbl->Encode;
  IME_Status = 0;

  /* mapping Ctrl+Shift+T to IM_VK_COMPOSE */
  if ((key_event->keyCode == 84) && (key_event->modifier == 3)) {
    key_event->keyCode = IM_VK_COMPOSE;
    key_event->keyChar = 0;
    key_event->modifier = 0;
  }

  /* if the keyevent is 'ESC', 'BackSpace'/'Delete', or C-foo or M-bar */
  if (Is_ClearAll_Key(hztbl, key_event->keyChar) ||
      Is_BackSpace_Key(hztbl, key_event->keyCode) || 
      (key_event->modifier & (IM_CTRL_MASK|IM_META_MASK|IM_ALT_MASK))) {
    if (Input_Len != 0)
      clean_all_area (ime_buffer);
    return (IME_NOT_USED_KEY);
  }

  /* ignore single modifier keys */
  switch (key_event->keyCode) {
  case IM_VK_SHIFT:
  case IM_VK_CAPS_LOCK:
  case IM_VK_MODECHANGE:
    return (IME_USED_KEY);
  }

  /* if keyCode is deadkey, compose or altgraph key, then use keyCode as the searching key */
  keychar = key_event->keyChar;
  if ((key_event->keyCode >= IM_VK_DEAD_GRAVE && key_event->keyCode <= IM_VK_DEAD_SEMIVOICED_SOUND) 
      || key_event->keyCode == IM_VK_COMPOSE 
      || key_event->keyCode == IM_VK_ALT_GRAPH)
    keychar = key_event->keyCode;

  if (keychar == 0)
    return (IME_NOT_USED_KEY);

  /* in Latin mode, if those are the first pressed keys, treat them as dead keys */
  if (Input_Len == 0 && !strcmp (hztbl->Cname, "Latin"))
  switch (keychar) {
  case IME_QUOTE:
    keychar = IM_VK_DEAD_ACUTE;
    break;
  case IME_BACK_QUOTE:
    keychar = IM_VK_DEAD_GRAVE;
    break;
  case IME_ASCIICIRCUM:
  case IME_GREATER:
    keychar = IM_VK_DEAD_CIRCUMFLEX;
    break;
  case IME_QUOTEDBL:
    keychar = IM_VK_DEAD_DIAERESIS;
    break;
  case IME_ASCIITILDE:
    keychar = IM_VK_DEAD_TILDE;
    break;
  }

  Input_Buf[Input_Len++] = keychar;
  Input_Buf[Input_Len++] = 0; 
  Input_Buf[Input_Len] = 0;
 
  int is_leaf;
  Lookup_Num = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, Lookup_Pos, Max_Lookup_Num, &is_leaf); 

  if (Lookup_Num == 0) {
    if (Input_Len != 0)
      clean_all_area (ime_buffer);
    return (IME_NOT_USED_KEY);
  }

  if (Lookup_Num == 1 && is_leaf)
    commit_candidate(ime_buffer, 0);

  return (IME_USED_KEY);
}
