/*
  Copyright 2002-2003 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <string.h>
#include "SunIM.h"
#include "unit_input.h"
#include "codetable.h"
#include "logf.h"

/*********************** Key Mapping ***********************/

/*  get the keys that IME will use */
int map_keyevent_to_imekey(CodeTableStruct *hztbl, IMEKey key_event)
{
  int keycode, keystatus, keychar;

  keycode = key_event->keyCode;
  keychar = key_event->keyChar;
  keystatus = key_event->modifier;
  log_f("keycode: 0x%x, keychar:0x%x, keystatus: 0x%x\n", keycode, keychar, keystatus);
  log_f("keycode: %d, keychar:%d, keystatus: %d\n", keycode, keychar, keystatus);

  /* normal status */
  if (keystatus  == 0) {
    /* Function Keys */
    if (keychar == 0) {
      log_f(" Function Key :%d\n", keycode);
      switch (keycode) {
      case IM_VK_ESCAPE:
	return(ESC_KEY);

      case IM_VK_BACK_SPACE:
	return(BACKSPACE_KEY);

      case IM_VK_ENTER:
	return(RETURN_KEY);

      case IM_VK_INSERT:
	return(INSERT_KEY);

      case IM_VK_DELETE:
	return(DELETE_KEY);

      case IM_VK_HOME:
	return(HOME_KEY);

      case IM_VK_END:
	return(END_KEY);

      case IM_VK_PAGE_UP:
	return(PAGEUP_KEY);

      case IM_VK_PAGE_DOWN:
	return(PAGEDOWN_KEY);

      case IM_VK_EURO_SIGN:
      case IM_VK_COMPOSE:
	return (keycode);

      case IM_VK_DEAD_GRAVE:
      case IM_VK_DEAD_ACUTE:
      case IM_VK_DEAD_CIRCUMFLEX:
      case IM_VK_DEAD_TILDE:
      case IM_VK_DEAD_MACRON:
      case IM_VK_DEAD_BREVE:
      case IM_VK_DEAD_ABOVEDOT:
      case IM_VK_DEAD_DIAERESIS:
      case IM_VK_DEAD_ABOVERING:
      case IM_VK_DEAD_DOUBLEACUTE:
      case IM_VK_DEAD_CARON:
      case IM_VK_DEAD_CEDILLA:
      case IM_VK_DEAD_OGONEK:
      case IM_VK_DEAD_IOTA:
      case IM_VK_DEAD_VOICED_SOUND:
      case IM_VK_DEAD_SEMIVOICED_SOUND:
        return(keycode);

      }
      return(IME_NOT_USED_KEY);
    } else {
      /*  normal key  */
      log_f(" Normal Key :0x%x, %c\n", keychar, keychar);
      if (!strcmp (hztbl->Cname, "Latin"))
      switch (keychar) {
      case IME_QUOTE:
	return IM_VK_DEAD_ACUTE;
      case IME_BACK_QUOTE:
	return IM_VK_DEAD_GRAVE;
      case IME_ASCIICIRCUM:
      case IME_GREATER:
        return IM_VK_DEAD_CIRCUMFLEX;
      case IME_QUOTEDBL:
        return IM_VK_DEAD_DIAERESIS;
      case IME_ASCIITILDE:
        return IM_VK_DEAD_TILDE;
      }
      return(keycode);
    }
  }

  /*  Shift status */
  if (keystatus == IM_SHIFT_MASK) {
    if (keychar == 0) {
      if ((keycode >= IM_VK_DEAD_GRAVE) && (keycode <= IM_VK_DEAD_SEMIVOICED_SOUND))
        return(keycode);
    } else if (keychar != 0) {
      /*  normal key  */
      log_f(" Ascii Key :0x%x, %c\n", keychar, keychar);
      if (!strcmp (hztbl->Cname, "Latin"))
      switch (keychar) {
        case IME_QUOTE:
	  return IM_VK_DEAD_ACUTE;
        case IME_BACK_QUOTE:
	  return IM_VK_DEAD_GRAVE;
        case IME_ASCIICIRCUM:
        case IME_GREATER:
          return IM_VK_DEAD_CIRCUMFLEX;
        case IME_QUOTEDBL:
          return IM_VK_DEAD_DIAERESIS;
        case IME_ASCIITILDE:
          return IM_VK_DEAD_TILDE;
      }
      return(keychar);
    }else
      return(IME_NOT_USED_KEY);
  }

  /*  Ctrl status */
  if (keystatus == IM_CTRL_MASK) {
    if (keychar != 0) {
      /*  normal key  */
      unsigned char *keylist;
      int i, key_id;

      keychar = keycode | 0x80;

      key_id = -1;
      for (i = 0; i<MAX_FUNCTIONKEY_NUM; i++) {
	keylist = hztbl->functionkey[i].keylist;
	if (*keylist) {
	  if (index(keylist, keychar)) {
	    key_id = i;
	    break;
	  }
	}
      }
			
      if (key_id != -1) {
	switch (key_id) {
	case PAGEUP_KEY_ID:
	  return(PAGEUP_KEY);
	case PAGEDOWN_KEY_ID:
	  return(PAGEDOWN_KEY);
	case BACKSPACE_KEY_ID:
	  return(BACKSPACE_KEY);
	case CLEARALL_KEY_ID:
	  return(ESC_KEY);
	}
      }
    }
  }

  if (keystatus & IM_ALT_GRAPH_MASK) {
    log_f("ALT_GRAPH_KEY is pressed \n");
    if (keycode != 0) 
      return(keycode);
  }

  if (keystatus == (IM_CTRL_MASK|IM_SHIFT_MASK)){
    log_f("COMPOSE KEY is pressed \n");
    if (keycode != 0) 
      return(keycode);
  }

  return (IME_NOT_USED_KEY);
}

