#ifndef IME_BUFFER_H
#define IME_BUFFER_H

#include "ime.h"

#define IME_PREEDIT_AREA                1
#define IME_LOOKUP_AREA                 2
#define IME_STATUS_AREA                 4
#define IME_COMMIT                      8

typedef struct _ImeBufferRec {
    ImePreeditRec       preedit;
    ImeCandidatesRec    candidates;
    unsigned char      *commit_buf;
    int                 return_status;
    int                 max_cand_num;  //used for free the space. do not use it any other place.
} ImeBufferRec;

ImeBufferRec * alloc_ime_buffer(int max_preedit_bytes,      //max byte lenght of the preedit buffer
                                int max_candidate_num,      //max number of candidates
                                int max_candidate_byte,     //max byte length of single candidates
                                int max_numberring_byte,    //max byte length of single numberring
                                int max_commit_byte);       //max byte length of the commit buffer

void free_ime_buffer(ImeBufferRec *ime_buffer);

void clear_ime_buffer(ImeBufferRec *ime_buffer);

#endif
