/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <sys/types.h>
#include <sys/stat.h>
#include "PYIM.h"
#include "UDCOper.h"

UDCData *udcGB, *udcGBK;
static time_t LastModifyTime = 0;

void DeleteUDCData() {
    UDCData *p, *q;
	
    p = udcGB;
    while(p != NULL) {
	q = p->next;
	free(p);
	p = q;
    }

    p = udcGBK;
    while(p != NULL) {
	q = p->next;
	free(p);
	p = q;
    }
    udcGB = udcGBK = NULL;
}

void GetUDCData() {
    FILE *fp;
    char buf[256], code[16];
    int state = GB_STATE;
    UDCData *p1, *p2, *q;
    int low, hi, i1, i2;
    struct stat statbuf;

    if(stat(UDC_DATA_PATH, &statbuf) == -1) return;
    if(LastModifyTime == statbuf.st_mtime) return;
    else LastModifyTime = statbuf.st_mtime;

    DeleteUDCData();
    
    p1 = udcGB = NULL; 
    p2 = udcGBK = NULL;
    i1 = i2 = 0;

    fp = fopen(UDC_DATA_PATH, "rb");
    if(fp == NULL) return;

    while(!feof(fp)) {
	fgets(buf, 256, fp);
	if(feof(fp)) break;
/*
printf("%s", buf);
*/

	if(!strncmp(buf, "[zh_CN.EUC]", 11)) {
	    state = GB_STATE;
	}
	else if(!strncmp(buf, "[zh_CN.GBK]", 11)) {
	    state = GBK_STATE;
	}
	else if(state == GB_STATE) {
	    if(strlen(buf) == 0) continue;
	    i1 ++;
	    q = (UDCData *) malloc(sizeof(UDCData)); 
	    q->id = i1;
	    q->next = NULL;
	    sscanf(buf, "%s %s\n", code, q->pinyin);
	    low = code[1] & 0xff;
	    hi = code[0] & 0xff;
	    q->nHzcode = ((hi << 8) & 0xFF00) + low ;
	    q->nYjcode = FastMatchYinJieStr(q->pinyin);
/*
printf("0x%x %s %d\n", q->nHzcode, q->pinyin, q->nYjcode);
*/
	    if(p1 != NULL) p1->next = q;
	    else udcGB = q;
	    p1 = q;
	}
	else if(state == GBK_STATE) {
	    if(strlen(buf) == 0) continue;
	    i2 ++;
	    q = (UDCData *) malloc(sizeof(UDCData)); 
	    q->id = i2;
	    q->next = NULL;
	    sscanf(buf, "%s %s\n", code, q->pinyin);
	    low = code[1] & 0xff;
	    hi = code[0] & 0xff;
	    q->nHzcode = ((hi << 8) & 0xFF00) + low ;
	    q->nYjcode = FastMatchYinJieStr(q->pinyin);
/*
printf("0x%x %s %d", q->nHzcode, q->pinyin, q->nYjcode);
*/
	    if(p2 != NULL) p2->next = q;
	    else udcGBK = q;
	    p2 = q;
	}
    }
    fclose(fp);
}

