/*

Copyright (c) 2006 Kenji ABE <abek@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#ifndef IM_LOOKUP_H
#define	IM_LOOKUP_H

#ifdef	__cplusplus
extern "C" {
#endif

extern Bool handle_lookup_choice_prev(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);
extern Bool handle_lookup_choice_next(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);
extern Bool handle_lookup_choice_prev_page(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);
extern Bool handle_lookup_choice_next_page(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);

extern Bool handle_lookup_choice_select_current(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);
extern Bool handle_lookup_choice_select_by_choice(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);

extern void start_lookup_choice(iml_session_t *session, iml_inst **inst_list);
extern void end_lookup_choice(iml_session_t *session, iml_inst **inst_list);

#ifdef __cplusplus
}
#endif

#endif /* IM_LOOKUP_H */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
