/*

Copyright (c) 2006 Kenji ABE <abek@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#ifndef IM_DEF_H
#define	IM_DEF_H

#include "SunIM.h"


#ifdef	__cplusplus
extern "C" {
#endif

/* data per desktop */
typedef struct {
    int dummy;
} PrivateDesktopData;

enum IM_STATE {
	IM_STATE_OFF = 0,
	IM_STATE_EDIT_EMPTY,
	IM_STATE_EDITING,
	IM_STATE_LETTER_TYPE_CONVERSION,
	IM_STATE_CONVERSION,
	IM_STATE_CHANGE_SEG,
	IM_STATE_PREDICTION,
};

typedef struct im_input_rec *im_input_t;
typedef struct im_conv_rec *im_conv_t;

/* data per session */
typedef struct {
    enum IM_STATE im_state;

    im_input_t im_input;

    im_conv_t im_conv;

    Bool draw_status_p;

    Bool preedit_p;
    int preedit_length;
/*    int preedit_cur_offset;*/
/*    int preedit_cur_length;*/

    Bool lookup_choice_p;
    int  lookup_choice_count;
    int  lookup_choice_cur_index;
    int  lookup_choice_list_top_index;
} PrivateSessionData;


#define DESKTOP_DATA(d) ((PrivateDesktopData*)(d)->specific_data)
#define SET_DESKTOP_DATA(d,v) (d)->specific_data = (v)

#define SESSION_DATA(s) ((PrivateSessionData*)(s)->specific_data)
#define SET_SESSION_DATA(s,v) (s)->specific_data = (v)

#define METHODS_TBL(s) ((s)->If->m)

#define N_FEEDBACK_TYPE (1)

extern Bool init_im(void);
extern void term_im(void);

extern Bool create_desktop_data(iml_desktop_t *desktop);
extern void free_desktop_data(iml_desktop_t *desktop);

extern Bool create_session_data(iml_session_t *session);
extern void free_session_data(iml_session_t *session);

extern void reset_session(iml_session_t *session);

extern void set_conversion_on(iml_session_t *session);
extern void set_conversion_off(iml_session_t *session);
extern void set_conversion_on_sub(iml_session_t *session, iml_inst **inst_list);

extern void key_list_event_handler(iml_session_t *session, IMKeyListEvent *key_list_event);

extern Bool change_im_state(iml_session_t *session, enum IM_STATE new_state, iml_inst **inst_list, Bool redraw_p);

#ifdef __cplusplus
}
#endif

#endif /* IM_DEF_H */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
