/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef KBLTRANS_KBLTRANS_H
#define KBLTRANS_KBLTRANS_H
#ifdef  __cplusplus
extern  "C" {
#endif   

typedef unsigned short UTF16_CHAR;

typedef struct _KBLTR_layout * KBLTR_layout;
typedef struct _KBLTR_context * KBLTR_context;

typedef enum {
    KEYEVENT,
    STRING,
} TRANS_TYPE;

typedef struct {
  int keycode;
  int keychar;
  int modifier;
  TRANS_TYPE type;
  UTF16_CHAR *str;
} KBLTR_keyevent;

enum KBLTR_MODIFIERS {
  KBLTR_SHIFT = 1,
  KBLTR_CONTROL = 2,
  KBLTR_META = 4,
  KBLTR_ALT = 8,
  KBLTR_CAPS = 16,
  KBLTR_ALT_GRAPH = 32
};
  
extern int kbltrans_init();
extern KBLTR_context kbltrans_get_context (const KBLTR_layout src, const KBLTR_layout dest);
extern void kbltrans_free_context (KBLTR_context ctx);
extern void kbltrans_free_keyevent (KBLTR_keyevent *kev);
extern const KBLTR_layout kbltrans_get_layout (const char *typename);
extern const KBLTR_layout kbltrans_get_layout_from_id (const int id);
extern KBLTR_keyevent *kbltrans_trans_keyevent (KBLTR_context ctx, const KBLTR_keyevent *src);
extern int kbltrans_trans_char_to_code (const KBLTR_layout layout, int keychar, int modifier);
extern int kbltrans_text_to_id (const char *typename);
extern char * kbltrans_id_to_text (int id);
extern void kbltrans_get_supported_layout_names (int *num, char*** layouts);
extern char * kbltrans_get_layout_name_by_locale (const char *lc_name);
extern int kbltrans_get_default_id ();
extern int kbltrans_get_platform_id ();
extern void kbltrans_add_custom_layout (char *name, char *source, int mod_key_num, char *strarray[], int intarray[]);

#define KBLTRANS_USER_LT(name, l) (l > 15 && !strncmp(name, "x-kbl-", 6) && (name[l - 6] == 'c' && name[l - 5] == 'u' && name[l - 4] == 's' && name[l - 3] == 't' && name[l - 2] == 'o' && name[l - 1] == 'm'))
  
#ifdef __cplusplus
}
#endif
#endif /* KBLTRANS_KBLTRANS_H */
