/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef _IIIMP_h
#define _IIIMP_h

#ifndef __XLIBINT_HH
#define __XLIBINT_HH
#include <X11/Xlibint.h>
#endif /* __XLIBINT_HH */
#include "Xlcint.h"

#define TRIGGER_KEY_LABEL "TRIGGER KEYS"
#define LANGLIST_MENU_LABEL "LE SWITCH"
#define CYCLE_LANG_SWITCH_LABEL "CYCLE LE SWITCH"
#define RE_CYCLE_LANG_SWITCH_LABEL "CYCLE LE SWITCH(reverse)"

enum IIIMF_MODIFIERS
{
  IIIMF_SHIFT_MODIFIER = 1,
  IIIMF_CONTROL_MODIFIER = 2,
  IIIMF_META_MODIFIER = 4,
  IIIMF_ALT_MODIFIER = 8,
  IIIMF_ALT_GRAPH_MODIFIER = 32
};

typedef enum {
  IM_DECORATION_FEEDBACK = 0,	/* IMNormal, IMReverse, IMUnderline */
  IM_FOREGROUND_RGB_FEEDBACK = 1,
  IM_BACKGROUND_RGB_FEEDBACK = 2,
  IM_UNDERLINE_RGB_FEEDBACK = 3
} IMFeedbackType;
#define IMFEEDBACK_LEN 4

typedef struct _IMFeedback {
  IMFeedbackType type;
  int   value;			/* depends on id-type */
} IMFeedback;

typedef struct _IMFeedbackList {
  unsigned int count_feedbacks;
  IMFeedback  *feedbacks;
} IMFeedbackList;

typedef struct _XIMDrawTextStgruct {
  XPointer call_data;
  IMFeedbackList  *feedback_list;
} XIMDrawTextStruct;

typedef enum    {
  DrawUpHorizontally = 0 ,
  DrawUpVertically = 1
} DrawUpDirection ;
 
typedef enum    {
  XIMOwnsLabel = 0 ,
  CBOwnsLabel = 1
} WhoOwnsLabel ;

typedef struct _XIMLookupStartCallbackStruct2 {
  int		which_is_master;
  int		choice_per_window;  /* Number of choices can be display
				     * in the region
				     */
  int		nrows;
  int		ncolumns;
  DrawUpDirection	draw_up_direction;
  WhoOwnsLabel	who_owns_label;
} XIMLookupStartCallbackStruct2;

typedef enum {
  NO_DECORATION = 0,
  BRACKET_DECORATION = 1
} LABEL_DECORATION;
typedef struct _XIMChoiceObject2 {
  LABEL_DECORATION label_decoration;
  XIMText         *label;
  IMFeedbackList  **label_feedback;
  XIMText         *value;
  IMFeedbackList  **value_feedback;
} XIMChoiceObject2;

typedef struct _XIMLookupDrawCallbackStruct2 {
  XIMChoiceObject2 *choices;       /* the lookup choices */
  int              n_choices;      /* Total number of lookup choices */
  int              first_index;
  int              last_index;
  int              current_index;
  XIMText	    *title;
} XIMLookupDrawCallbackStruct2;

typedef struct _XIMLookupProcessCallbackStruct2 {
  int type;
  union {
    int	index_of_choice_selected;/* Set by callback for the
				  * selected choice.
				  * XIM_UNKNOW_KEYSYM and
				  * XIM_UNDETERMINED are
				  * also possible value.
				  */
    int index_of_page_selected;
  } data;
} XIMLookupProcessCallbackStruct2;

#endif /* _IIIMP_h */
