/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef LECUSTOMDATA_HH_
#define LECUSTOMDATA_HH_

#include <iconv.h>
#include <string>
#include <vector>
#include <iiimp.h>
#include "basictype.hh"
#include "IMArg.h"

class LECustomData
{
public:
  LECustomData(IIIMP_aux_setvalues_v *pauxval);
  ~LECustomData();

  IMArgList get_IMArgList ();
  int get_IMArg_num ();

private:
  static IIIMP_card16 *empty_str;
  vector<IIIMP_card32> *i_vector;
  vector<IIIMP_card16 *> *s_vector;

  char *make_utf8_charstr(IIIMP_card16 *);
  int UTFSTR_len(IIIMP_card16 *utf16) {
    int i;
    for (i = 0; utf16[i]; i++) {}
    return i;
  };
  static bool iconv_init;
  static iconv_t utf16to8_cd;
  static size_t ICONV_BUF_SIZ;
  static char *iconv_buf;

  static int id;
};

#endif /* not LECUSTOMDATA_HH_ */
