#include <config.h>
#include <stdio.h>
#include "IMInputContext.hh"
#include "IMConnection.hh"
#include "IMSvr.hh"
#include "LEMgr.hh"
#include "IMLog.hh"
#include "IMArg.h"

//
// LEContext management.
//

LEMgr*
IMInputContext::get_lemgr()
{
    return get_imconnection()->get_imsvr()->get_lemgr();
}

LEContext*
IMInputContext::create_lecontext()
{
    LEContext* plec;

    plec = get_lemgr()->choose_LE(this);
    if (plec) {
      leclist.push_back(plec);

      /* if choosed LE is unitle, then user defined keyboard layout data
	 (IMDesktop::custom_data) is passed to LE. */
      iml_if_t *ifs = plec->get_iml_if();
      if (!strcmp (ifs->if_name, "unitle")) {
	/* get custom layout info from IMDesktop if it has it. */
	IMDesktop *desktop = get_imconnection()->get_desktop();
	vector<LECustomData *> *data_vec = desktop->get_lecustom_data();
	if (data_vec != NULL && data_vec->size() > 0) {
	  /* send it through if_SetIFValues */
	  vector<LECustomData *>::iterator itr;
	  for (itr = data_vec->begin(); itr < data_vec->end(); itr++) {
	    IMArgList args = (*itr)->get_IMArgList ();
	    int num_args = (*itr)->get_IMArg_num ();
	    if_SetIFValues (ifs, args, num_args);

	    for (int i = 0; i < num_args; i++) {
	      if (args[i].id == 1) {
		free (args[i].value); // allocated by strdup()
	      }
	    }
	    delete[] args;
	  }
	  desktop->set_lecustom_data(NULL);
	}
      }
    }
    return plec;
}

LEContext*
IMInputContext::get_current_lecontext()
{
    if (pcur_lec) return pcur_lec;
    pcur_lec = create_lecontext();

    if (!pcur_lec) {
	LOG_ERROR("Failed to create LE context.");
    }
    //TODO attr = pcur_lec->get_icattribute();
    return pcur_lec;
}

bool
IMInputContext::switch_lecontext(
    const ICAttribute &x_attr
)
{
    // TODO  spcicial client HTT_XBE requires this feature...
    return false;
}

//
// service for LEContext.
//

void
IMInputContext::get_lecontext_args(
    vector<IMArg> &args
)
{
    IMArg a;

    IMSetArg(a, SC_CLIENT_LOCALE,
	     attr.get_inputlanguage().get_charstr());
    args.push_back(a);
    IMSetArg(a, SC_CLIENT_INPUT_METHOD_NAME,
	     attr.get_inputmethod().get_charstr());
    args.push_back(a);
    IMSetArg(a, SC_CLIENT_CHARACTER_SUBSETS,
	     attr.get_character_subsets().get_c_csidices());
    args.push_back(a);
    IMSetArg(a, SC_CLIENT_KBD_LAYOUT, attr.get_kbdlayout());
    args.push_back(a);

    return;
}

/*******************************************************************************
                        ICHandler realization
*******************************************************************************/

bool
IMInputContext::send_event(
    IMLExec* pimlex,
    IMInputEvent* pimevent
)
{
#if 0 // AUX forwarding... TODO!!!!
    if (fev->type == IM_EventAux) {
	IMAuxEvent *aux_event = (IMAuxEvent*)fev;
	ImlSession *temp_session;

	for (int i = 1; i <= session_list.getSize(); i++) {
	    temp_session = (ImlSession *)&(session_list.getItem(i));
	    int len = temp_session->mAuxName.length();
	    if (len > 0 && strstr(aux_event->aux->aux_name,
				  (const char*)temp_session->mAuxName)) {
		sc = temp_session->sc;
		break;
	    }
	}
#if 0
	// not found, save current aux name for later comparison.
	if (active_session->mAuxName.length() == 0) {
	    char *p = 0;
	    char *aux_name = strdup(aux_event->aux->aux_name);
	    if (p = rindex (aux_name, '.'))
		*p = 0;
	    active_session->mAuxName = CompoundString(aux_name);
	    free (aux_name);
	}
#endif
    }
#endif
    LEContext *plec = get_current_lecontext();

    if (!plec) return false;

    return plec->send_event(pimlex, pimevent);
}

bool
IMInputContext::send_event_getvalues(
    IMLExec* pimlex,
    IMInputEvent* pimevent
)
{
    LEContext *plec = get_current_lecontext();

    if (!plec) return false;

    return plec->send_event_getvalues(pimlex, pimevent);
}

bool
IMInputContext::send_event_getvalues_finished(
    IMLExec* pimlex
)
{
    LEContext *plec = get_current_lecontext();

    if (!plec) return false;

    return plec->send_event_getvalues_finished(pimlex);
}

const ICAttribute&
IMInputContext::get_icattr()
{
    return attr;
}

bool
IMInputContext::set_icattr(
    const ICAttribute &x_attr
)
{
    attr = x_attr;
    // TODO...
    pcur_lec = create_lecontext();

    return true;
}

bool
IMInputContext::toggle_conversion(
    IMLExec *pimlex,
    bool flag
)
{
    LEContext *plec = get_current_lecontext();

    if (!plec) return false;

    return plec->toggle_conversion(pimlex, flag);
}

bool
IMInputContext::invoke_desktop_listener(
    IMLExec *pimlex,
    int listener_id,
    int file_size,
    void *object
)
{
    LEContext *plec = get_current_lecontext();
    iml_desktop_t *desktop = plec->get_iml_desktop();
    iml_listener_t *l;

    if (!plec) return false;

    l = desktop->lookupListenerFromDesktop(plec->get_iml_session(), listener_id);
    l->listener(listener_id, file_size, object, l->private_data);
   
    return true;
}

iml_desktop_t *
IMInputContext::get_current_desktop()
{
    LEContext *plec = get_current_lecontext();

    if (plec == NULL) return NULL;

    return plec->get_iml_desktop();
}

bool
IMInputContext::reset(
    IMLExec *pimlex
)
{
    LEContext *plec = get_current_lecontext();

    if (!plec) return false;

    return plec->reset(pimlex);
}

bool
IMInputContext::destroy(
    IMLExec *pimlex
)
{
    LEContextList::iterator i;
    for (i = leclist.begin(); i != leclist.end(); i++) {
	(*i)->destroy(pimlex);
    }
    delete this;
    return true;
}

void
IMInputContext::destroy()
{
    destroy_all(leclist);
    delete this;
}

bool
IMInputContext::toggle_focus(
    IMLExec *pimlex,
    bool flag
)
{
    LEContext *plec = get_current_lecontext();

    if (!plec) return false;

    return plec->toggle_focus(pimlex, flag);
}

/*******************************************************************************
                       Constructor/Destructor
*******************************************************************************/

IMInputContext::IMInputContext(
    IMConnection *x_pimc,
    const ICAttribute &x_attr
)
{
    pimc = x_pimc;
    attr = x_attr;
    pcur_lec = NULL;
}

IMInputContext::~IMInputContext()
{
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
