#ifndef IMHANDLER_HH_
#define IMHANDLER_HH_
#include <string>
#include <list>
#include "basictype.hh"
#include "IMBasicObject.hh"
#include "IMHotkey.hh"
#include "ICHandler.hh"
#include "IMKeyUtils.hh"

class IMHandler
{
  public:
    enum CLIENTINFO_ATTR{
	    CLIENT_NAME,
	    OS_NAME,
	    OS_ARCH,
	    OS_VERSION,
	    // non-normative items.
	    X_DISPLAY_NAME,
	    X_SERVER_VENDOR,
	    CLIENT_GROUP
    };
    struct ClientAttr {
	enum CLIENTINFO_ATTR attr;
	u16string val;
	ClientAttr(enum CLIENTINFO_ATTR a, const u16string &v)
	    : attr(a), val(v)
	{}
    };
    typedef list<ClientAttr> ClientAttrList;

    virtual bool set_client_info(
	const ClientAttrList& attrlist
    ) = 0;

    virtual bool get_triggerkeys(
	IMKeySpecList &onkeys,
	IMKeySpecList &offkeys
    ) = 0;
    virtual const IMLangList* get_langlist(iml_desktop_t *) = 0;
    virtual const IMObjectWithDescList* get_imobjectdesclist() = 0;
    virtual IMHotkeyProfileStruct* get_hotkey_profiles(int *count_profiles) = 0;
    virtual const IMDescriptorList* get_imdesclist(iml_desktop_t *) = 0;
    virtual const bool update_imdesclist(
        IMLEName *LEname,
        IMLocale *Locales,
        int nLocales
    ) = 0;
    virtual const IMObject* get_imobject(
	int attribid
    ) = 0;
    virtual ICHandler* createic(
	ICAttribute &icattr
    ) = 0;
    virtual void destroy() = 0;
};

#endif /* not IMHANDLER_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
