/*
 * fop.h: iml file operation - private header file
 */

#if !defined(IIIMF_FOP_H)
#define IIIMF_FOP_H

#include <dirent.h>
#include <utime.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/uio.h>

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */


typedef struct _fop_file	fop_file_t;
typedef struct _fop_uri		fop_uri_t;

typedef struct {
    char *		le;
    int			type;
    void *		owner;
    fop_uri_t *		requireuri;
    fop_file_t *	file;
} fopc_t;


typedef int	(* fop_close_t)(fopc_t *, void *);
typedef void *	(* fop_creat_t)(fopc_t *, const char *, mode_t);
typedef int	(* fop_ftruncate_t)(fopc_t *, void *, off_t);
typedef off_t	(* fop_lseek_t)(fopc_t *, void *, off_t, int);
typedef void *	(* fop_open_t)(fopc_t *, const char *, int, mode_t);
typedef ssize_t	(* fop_read_t)(fopc_t *, void *, void *, size_t);
typedef int	(* fop_truncate_t)(fopc_t *, const char *, off_t);
typedef ssize_t	(* fop_write_t)(fopc_t *, void *, const void *, size_t);

typedef int	(* fop_link_t)(fopc_t *, const char *, const char *);
typedef int	(* fop_readlink_t)(fopc_t *, const char *, char *, size_t);
typedef int	(* fop_rename_t)(fopc_t *, const char *, const char *);
typedef int	(* fop_symlink_t)(fopc_t *, const char *, const char *);
typedef int	(* fop_unlink_t)(fopc_t *, const char *);

typedef int	(* fop_chmod_t)(fopc_t *, const char *, mode_t);
typedef int	(* fop_chown_t)(fopc_t *, const char *, uid_t, gid_t);
typedef int	(* fop_fchmod_t)(fopc_t *, void *, mode_t);
typedef int	(* fop_fchown_t)(fopc_t *, void *, uid_t, gid_t);
typedef int	(* fop_lchown_t)(fopc_t *, const char *, uid_t, gid_t);

typedef int	(* fop_utime_t)(fopc_t *, const char *,
				const struct utimbuf *);
typedef int	(* fop_utimes_t)(fopc_t *, const char *,
				 const struct timeval *);

typedef int	(* fop_fstat_t)(fopc_t *, void *, struct stat *);
typedef int	(* fop_lstat_t)(fopc_t *, const char *, struct stat *);
typedef int	(* fop_stat_t)(fopc_t *, const char *, struct stat *);
typedef int	(* fop_access_t)(fopc_t *, const char *, int);

typedef int	(* fop_closedir_t)(fopc_t *, void *);
typedef void *	(* fop_opendir_t)(fopc_t *, const char *);
typedef struct dirent *	(* fop_readdir_t)(fopc_t *, void *);
typedef void	(* fop_rewinddir_t)(fopc_t *, void *);
typedef void	(* fop_seekdir_t)(fopc_t *, void *, long int);
typedef long int(* fop_telldir_t)(fopc_t *, void *);

typedef int	(* fop_mkdir_t)(fopc_t *, const char *, mode_t);
typedef int	(* fop_rmdir_t)(fopc_t *, const char *);

typedef int	(* fop_fcntl_t)(fopc_t *, void *, int, ...);

#if defined(fop_not_defined)
typedef ssize_t	(* fop_readv_t)(fopc_t *, void *, const struct iovec *, int);
typedef ssize_t	(* fop_writev_t)(fopc_t *, void *, const struct iovec *, int);
typedef long	(* fop_pathconf_t)(fopc_t *, const char *, int);
typedef long	(* fop_fpathconf_t)(fopc_t *, void *, int);
#endif /* fop_not_defined */


#if defined(__cplusplus)
}
#endif /* __cplusplus */

#endif /* !IIIMF_FOP_H */
