/*
 * Copyright (C) 2000 Red Hat Software
 * Copyright (C) 2003 Motonobu Ichimura
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Hidetoshi Tajima <hidetoshi.tajima@sun.com>
 */

#ifndef __IM_SWITCHER_H
#define __IM_SWITCHER_H

/* exported from imswitcher.c to gtkimcontextiiim.c */
extern gboolean im_info_switcher_active (GtkIIIMInfo *info);
extern gboolean	im_info_switcher_new (GtkIIIMInfo *info);
extern void	im_info_switcher_shutdown (GtkIIIMInfo *info);

extern void im_context_switcher_new (GtkIMContextIIIM *context_iiim);
extern void im_context_switcher_finalize (GtkIMContextIIIM *context_iiim);

extern void im_context_switcher_set_switcher_list (GtkIMContextIIIM *context_iiim,
						   gchar *switcher_list);
extern void im_context_switcher_set_language_list (GtkIMContextIIIM *context_iiim,
						   IIIMCF_language *lang_list,
						   int n_lang);
extern void im_context_switcher_set_status_text (GtkIMContextIIIM *context_iiim,
						 gchar *utf8);
extern void im_context_switcher_set_focus (GtkIMContextIIIM *context_iiim);
extern void im_context_switcher_set_input_language (GtkIMContextIIIM *context_iiim,
						    gchar *input_lang);
extern void im_context_switcher_set_language_engine_list (GtkIMContextIIIM *context_iiim,
							  gchar *le_list);
extern void im_context_switcher_set_conversion_mode (GtkIMContextIIIM *context_iiim);
extern void IIIMSetHotkey (GtkIMContextIIIM *);

#endif

/* Local Variables: */
/* c-file-style: "gnu" */
/* End: */
