/*
  IIIMGdkEventKey.h
  Copyright (C) 2003 Free Standards Group

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL OPENI18N WG OR FREE STANDARDS GROUP. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

  Except as contained in this notice, the names of OpenI18N WG and/or
  Free Standards Group shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from OpenI18N WG and/or Free Standards Group
  as applicable.

  Author: MIYASHITA, Hisashi <himi@OpenI18N.org>

*/
#ifndef IIIMGDKEVENTKEY_H_
#define IIIMGDKEVENTKEY_H_
#include <iiimcf.h>
#include <gdk/gdk.h>

enum IIIMF_MODIFIERS
{
  IIIMF_SHIFT_MODIFIER = 1,
  IIIMF_CONTROL_MODIFIER = 2,
  IIIMF_META_MODIFIER = 4,
  IIIMF_ALT_MODIFIER = 8,
  IIIMF_ALT_GRAPH_MODIFIER = 32
};

extern IIIMF_status
convert_GdkEventKey_to_IIIMCF_keyevent (GdkEventKey * e,
					IIIMCF_keyevent * pkev);

extern IIIMF_status
convert_IIIMCF_keyevent_to_GdkEventKey (IIIMCF_keyevent * pkev,
					GdkEventKey * e);
extern int g2icode (guint);

#endif /* not IIIMGDKEVENTKEY_H_ */

/* Local Variables: */
/* c-file-style: "gnu" */
/* End: */
