/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class IntroduceIndirectionAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public IntroduceIndirectionAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(true);
    }

    public IntroduceIndirectionAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.IntroduceIndirectionAction_title);
        this.setToolTipText(RefactoringMessages.IntroduceIndirectionAction_tooltip);
        this.setDescription(RefactoringMessages.IntroduceIndirectionAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.introduce_indirection_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        block2: {
            try {
                this.setEnabled(RefactoringAvailabilityTester.isIntroduceIndirectionAvailable(selection));
            }
            catch (JavaModelException e) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block2;
                JavaPlugin.log(e);
            }
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isIntroduceIndirectionAvailable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            Assert.isTrue((boolean)RefactoringAvailabilityTester.isIntroduceIndirectionAvailable(selection));
            Object first = selection.getFirstElement();
            Assert.isTrue((boolean)(first instanceof IMethod));
            this.run((IMethod)first);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.IntroduceIndirectionAction_dialog_title, RefactoringMessages.IntroduceIndirectionAction_unknown_exception);
        }
    }

    public void run(ITextSelection selection) {
        try {
            IJavaElement editorInput = SelectionConverter.getInput(this.fEditor);
            if (editorInput instanceof ICompilationUnit) {
                this.run(selection.getOffset(), selection.getLength(), (ICompilationUnit)editorInput);
            } else if (editorInput instanceof IClassFile) {
                this.run(selection.getOffset(), selection.getLength(), (IClassFile)editorInput);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.IntroduceIndirectionAction_dialog_title, RefactoringMessages.IntroduceIndirectionAction_unknown_exception);
        }
    }

    private void run(int offset, int length, ICompilationUnit unit) throws JavaModelException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)unit)) {
            return;
        }
        RefactoringExecutionStarter.startIntroduceIndirectionRefactoring(unit, offset, length, this.getShell());
    }

    private void run(int offset, int length, IClassFile file) throws JavaModelException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)file)) {
            return;
        }
        RefactoringExecutionStarter.startIntroduceIndirectionRefactoring(file, offset, length, this.getShell());
    }

    private void run(IMethod method) throws JavaModelException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)method)) {
            return;
        }
        RefactoringExecutionStarter.startIntroduceIndirectionRefactoring(method, this.getShell());
    }
}

