/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.ui.actions.FindReferencesAction;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class FindReferencesInWorkingSetAction
extends FindReferencesAction {
    private IWorkingSet[] fWorkingSets;

    public FindReferencesInWorkingSetAction(IWorkbenchSite site) {
        this(site, (IWorkingSet[])null);
    }

    public FindReferencesInWorkingSetAction(IWorkbenchSite site, IWorkingSet[] workingSets) {
        super(site);
        this.fWorkingSets = workingSets;
    }

    public FindReferencesInWorkingSetAction(JavaEditor editor) {
        this(editor, null);
    }

    public FindReferencesInWorkingSetAction(JavaEditor editor, IWorkingSet[] workingSets) {
        super(editor);
        this.fWorkingSets = workingSets;
    }

    void init() {
        this.setText(SearchMessages.Search_FindReferencesInWorkingSetAction_label);
        this.setToolTipText(SearchMessages.Search_FindReferencesInWorkingSetAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_REF);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.find_references_in_working_set_action");
    }

    QuerySpecification createQuery(IJavaElement element) throws JavaModelException, InterruptedException {
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        IWorkingSet[] workingSets = this.fWorkingSets;
        if (this.fWorkingSets == null && (workingSets = factory.queryWorkingSets()) == null) {
            return super.createQuery(element);
        }
        SearchUtil.updateLRUWorkingSets(workingSets);
        IJavaSearchScope scope = factory.createJavaSearchScope(workingSets, true);
        String description = factory.getWorkingSetScopeDescription(workingSets, true);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

