/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.VariableDeclarationFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class VariableDeclarationCleanUp
extends AbstractCleanUp {
    public VariableDeclarationCleanUp(Map options) {
        super(options);
    }

    public VariableDeclarationCleanUp() {
    }

    public boolean requireAST(ICompilationUnit unit) throws CoreException {
        boolean addFinal = this.isEnabled("cleanup.make_variable_declarations_final");
        if (!addFinal) {
            return false;
        }
        return this.isEnabled("cleanup.make_private_fields_final") || this.isEnabled("cleanup.make_parameters_final") || this.isEnabled("cleanup.make_local_variable_final");
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean addFinal = this.isEnabled("cleanup.make_variable_declarations_final");
        if (!addFinal) {
            return null;
        }
        return VariableDeclarationFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.make_private_fields_final"), this.isEnabled("cleanup.make_parameters_final"), this.isEnabled("cleanup.make_local_variable_final"));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    public Map getRequiredOptions() {
        return null;
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_private_fields_final")) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalField_description);
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_parameters_final")) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalParameters_description);
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_local_variable_final")) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalLocals_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_private_fields_final")) {
            buf.append("private final int i= 0;\n");
        } else {
            buf.append("private int i= 0;\n");
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_parameters_final")) {
            buf.append("public void foo(final int j) {\n");
        } else {
            buf.append("public void foo(int j) {\n");
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_local_variable_final")) {
            buf.append("    final int k;\n");
            buf.append("    int h;\n");
            buf.append("    h= 0;\n");
        } else {
            buf.append("    int k, h;\n");
            buf.append("    h= 0;\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }
}

