/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.internal.core.AntObject;
import org.eclipse.ant.internal.ui.preferences.AntContentProvider;
import org.eclipse.ant.internal.ui.preferences.AntObjectLabelProvider;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.AntRuntimePreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public abstract class AntPage {
    protected static final int ADD_BUTTON = 1025;
    protected static final int EDIT_BUTTON = 1026;
    protected static final int REMOVE_BUTTON = 1027;
    protected SelectionAdapter selectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AntPage.this.buttonPressed((Integer)e.widget.getData());
        }
    };
    private AntRuntimePreferencePage preferencePage;
    private TableViewer tableViewer;
    private AntContentProvider contentProvider;
    protected Button editButton;
    protected Button removeButton;
    private final String[] fTableColumnHeaders = new String[]{AntPreferencesMessages.AntPage_0, AntPreferencesMessages.AntPage_1, AntPreferencesMessages.AntPage_2, AntPreferencesMessages.AntPage_3};
    private final ColumnLayoutData[] fTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(40), new ColumnWeightData(20), new ColumnWeightData(20), new ColumnWeightData(20)};

    public AntPage(AntRuntimePreferencePage preferencePage) {
        this.preferencePage = preferencePage;
    }

    protected abstract void addButtonsToButtonGroup(Composite var1);

    protected abstract void initialize();

    protected void addContent(Object o) {
        if (this.contentProvider != null) {
            this.contentProvider.add(o);
        }
    }

    private void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.add();
                break;
            }
            case 1026: {
                this.edit(this.getSelection());
                break;
            }
            case 1027: {
                this.remove();
            }
        }
    }

    protected Button createPushButton(Composite parent, String buttonText, int buttonId) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(buttonText);
        button.setData((Object)new Integer(buttonId));
        button.addSelectionListener((SelectionListener)this.selectionAdapter);
        this.preferencePage.setButtonLayoutData(button);
        return button;
    }

    protected void createButtonGroup(Composite top) {
        Composite buttonGroup = new Composite(top, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)new GridData(1040));
        buttonGroup.setFont(top.getFont());
        this.addButtonsToButtonGroup(buttonGroup);
    }

    protected void createTable(Composite parent) {
        Table table = new Table(parent, 67586);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = table.getItemHeight();
        data.horizontalSpan = 1;
        table.setLayoutData((Object)data);
        table.setFont(parent.getFont());
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int i = 0;
        while (i < this.fTableColumnHeaders.length) {
            tableLayout.addColumnData(this.fTableColumnLayouts[i]);
            TableColumn column = new TableColumn(table, 0, i);
            column.setResizable(this.fTableColumnLayouts[i].resizable);
            column.setText(this.fTableColumnHeaders[i]);
            ++i;
        }
        this.contentProvider = this.getContentProvider();
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AntObjectLabelProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AntPage.this.tableSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty() && AntPage.this.editButton.isEnabled()) {
                    AntPage.this.edit((IStructuredSelection)event.getSelection());
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (AntPage.this.editButton.isEnabled() && event.character == '\u007f' && event.stateMask == 0) {
                    AntPage.this.remove(AntPage.this.tableViewer);
                }
            }
        });
    }

    protected AntContentProvider getContentProvider() {
        return new AntContentProvider();
    }

    protected List getContents(boolean forDisplay) {
        if (this.tableViewer == null || this.tableViewer.getControl().isDisposed()) {
            return null;
        }
        List entries = this.getPreferencePage().getLibraryEntries();
        Object[] elements = this.contentProvider.getElements(this.tableViewer.getInput());
        ArrayList<Object> contents = new ArrayList<Object>(elements.length);
        int i = 0;
        while (i < elements.length) {
            block6: {
                Object element;
                block5: {
                    element = elements[i];
                    if (!(element instanceof AntObject)) break block5;
                    AntObject antObject = (AntObject)element;
                    if (forDisplay ? !antObject.isDefault() && !entries.contains(antObject.getLibraryEntry()) : antObject.isDefault() || !entries.contains(antObject.getLibraryEntry())) break block6;
                }
                contents.add(element);
            }
            ++i;
        }
        return contents;
    }

    protected final IStructuredSelection getSelection() {
        if (this.tableViewer == null || this.tableViewer.getControl().isDisposed()) {
            return null;
        }
        return (IStructuredSelection)this.tableViewer.getSelection();
    }

    protected final Shell getShell() {
        if (this.tableViewer == null || this.tableViewer.getControl().isDisposed()) {
            return null;
        }
        return this.tableViewer.getControl().getShell();
    }

    protected void remove() {
        this.remove(this.tableViewer);
    }

    protected void remove(TableViewer viewer) {
        AntContentProvider antContentProvider = (AntContentProvider)viewer.getContentProvider();
        IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
        Iterator itr = sel.iterator();
        while (itr.hasNext()) {
            antContentProvider.remove(itr.next());
        }
    }

    protected void setInput(List inputs) {
        if (this.tableViewer == null || this.tableViewer.getControl().isDisposed()) {
            return;
        }
        this.tableViewer.setInput((Object)inputs);
        this.tableSelectionChanged((IStructuredSelection)this.tableViewer.getSelection());
    }

    protected final void updateContent(Object element) {
        if (this.tableViewer == null || this.tableViewer.getControl().isDisposed()) {
            return;
        }
        this.tableViewer.update(element, null);
    }

    protected Composite createContents(Composite top) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)top, this.getHelpContextId());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        this.createTable(top);
        this.createButtonGroup(top);
        return top;
    }

    protected AntRuntimePreferencePage getPreferencePage() {
        return this.preferencePage;
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected void tableSelectionChanged(IStructuredSelection newSelection) {
        int size = newSelection.size();
        boolean enabled = true;
        Iterator itr = newSelection.iterator();
        while (itr.hasNext()) {
            AntObject antObject;
            Object element = itr.next();
            if (!(element instanceof AntObject) || !(antObject = (AntObject)element).isDefault()) continue;
            enabled = false;
            break;
        }
        this.editButton.setEnabled(enabled && size == 1);
        this.removeButton.setEnabled(enabled && size > 0);
    }

    protected abstract void edit(IStructuredSelection var1);

    protected abstract void add();

    protected abstract String getHelpContextId();

    protected void connectToFolder(final TabItem item, TabFolder folder) {
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item == item) {
                    AntPage.this.setInput(AntPage.this.getContents(true));
                }
            }
        });
    }
}

