'use strict'

import test from 'ava'
import isCidr, { isCidrV4, isCidrV6 } from '../src'

const v4 = [
  '0.0.0.0/16',
  '8.8.8.8/17',
  '127.0.0.1/18',
  '100.100.100.100/19',
  '192.168.0.1/20',
  '18.101.25.153/24',
  '123.23.34.2/25',
  '172.26.168.134/26',
  '212.58.241.131/27',
  '128.0.0.0/28',
  '23.71.254.72/29',
  '223.255.255.255/30',
  '192.0.2.235/31',
  '99.198.122.146/32',
  '46.51.197.88/8',
  '173.194.34.134/12'
]

const v4not = [
  '.100.100.100.100/16',
  '100..100.100.100./24',
  '100.100.100.100./32',
  '999.999.999.999/12',
  '256.256.256.256/30',
  '256.100.100.100.100/26',
  '123.123.123/31',
  'http://123.123.123/28',
  '1000.2.3.4/14',
  '999.2.3.4/8'
]

const v6 = [
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/0',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/1',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/2',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/3',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/5',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/6',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/7',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/8',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/9',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/11',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/12',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/13',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/14',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/15',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/16',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/17',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/18',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/19',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/20',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/21',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/22',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/23',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/24',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/25',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/26',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/27',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/28',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/29',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/30',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/31',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/32',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/33',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/34',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/35',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/36',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/37',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/38',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/39',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/40',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/41',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/42',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/43',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/44',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/45',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/46',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/47',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/48',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/49',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/50',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/51',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/52',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/53',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/54',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/55',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/56',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/57',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/58',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/59',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/60',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/61',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/62',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/63',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/64',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/65',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/66',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/67',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/68',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/69',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/70',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/71',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/72',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/73',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/74',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/75',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/76',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/77',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/78',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/79',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/80',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/81',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/82',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/83',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/84',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/85',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/86',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/87',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/88',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/89',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/90',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/91',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/92',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/93',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/94',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/95',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/96',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/97',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/98',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/99',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/100',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/101',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/102',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/103',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/104',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/105',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/106',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/107',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/108',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/109',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/110',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/111',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/112',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/113',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/114',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/115',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/116',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/117',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/118',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/119',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/120',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/121',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/122',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/123',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/124',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/125',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/126',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/127',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/128',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156'
]

const v6not = [
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/129',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/a',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/√',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/00',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/03',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/sdfsdfs',
  'fe80:0000:0000:0000:0204:61ff:fe9d:f156/'
]

test('cidr v4', (t) => {
  v4.forEach((string) => {
    t.true(isCidr(string))
  })

  v4not.forEach((string) => {
    t.false(isCidrV4(string))
  })
})

test('cidr v6', (t) => {
  v6.forEach((string) => {
    t.true(isCidrV6(string))
  })

  v6not.forEach((string) => {
    t.false(isCidrV6(string))
  })
})
