/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image.codec;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import sun.awt.image.codec.JPEGParam;

public class JPEGImageEncoderImpl
implements JPEGImageEncoder {
    private static final String JPGMime = "image/jpeg";
    private ImageWriter JPGWriter;
    private JPEGEncodeParam param;
    private OutputStream out;

    public JPEGImageEncoderImpl(OutputStream os) {
        this(os, null);
    }

    public JPEGImageEncoderImpl(OutputStream out, JPEGEncodeParam newParam) {
        this.out = out;
        this.setJPEGEncodeParam(newParam);
        Iterator<ImageWriter> JPGWriterIter = ImageIO.getImageWritersByMIMEType(JPGMime);
        if (JPGWriterIter.hasNext()) {
            this.JPGWriter = JPGWriterIter.next();
        }
        this.JPGWriter.setOutput(new MemoryCacheImageOutputStream(out));
    }

    @Override
    public JPEGEncodeParam getDefaultJPEGEncodeParam(BufferedImage bi) throws ImageFormatException {
        return JPEGCodec.getDefaultJPEGEncodeParam(bi);
    }

    @Override
    public JPEGEncodeParam getDefaultJPEGEncodeParam(int numBands, int colorID) throws ImageFormatException {
        return JPEGCodec.getDefaultJPEGEncodeParam(numBands, colorID);
    }

    @Override
    public JPEGEncodeParam getDefaultJPEGEncodeParam(JPEGDecodeParam d) throws ImageFormatException {
        return JPEGCodec.getDefaultJPEGEncodeParam(d);
    }

    @Override
    public JPEGEncodeParam getDefaultJPEGEncodeParam(Raster ras, int colorID) throws ImageFormatException {
        return JPEGCodec.getDefaultJPEGEncodeParam(ras, colorID);
    }

    @Override
    public JPEGEncodeParam getJPEGEncodeParam() throws ImageFormatException {
        if (this.param == null) {
            return null;
        }
        return (JPEGEncodeParam)this.param.clone();
    }

    @Override
    public void setJPEGEncodeParam(JPEGEncodeParam p) {
        this.param = p;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    private void encode(IIOImage img) throws IOException, ImageFormatException {
        if (this.JPGWriter == null) {
            throw new ImageFormatException("JPEG writer code not implemented in ImageIO");
        }
        JPEGImageWriteParam jiwp = new JPEGImageWriteParam(null);
        jiwp.setCompressionMode(2);
        if (this.param != null && this.param instanceof JPEGParam) {
            JPEGParam jp = (JPEGParam)this.param;
            jiwp.setCompressionQuality(jp.getQuality());
        } else {
            jiwp.setCompressionQuality(0.75f);
        }
        this.JPGWriter.write(null, img, jiwp);
    }

    @Override
    public void encode(BufferedImage bi, JPEGEncodeParam writeParam) throws IOException, ImageFormatException {
        this.setJPEGEncodeParam(writeParam);
        this.encode(new IIOImage(bi, new ArrayList(), null));
    }

    @Override
    public void encode(Raster rs, JPEGEncodeParam writeParam) throws IOException, ImageFormatException {
        this.setJPEGEncodeParam(writeParam);
        this.encode(new IIOImage(rs, new ArrayList(), null));
    }

    @Override
    public void encode(BufferedImage bi) throws IOException, ImageFormatException {
        this.encode(bi, null);
    }

    @Override
    public void encode(Raster rs) throws IOException, ImageFormatException {
        this.encode(rs, null);
    }

    @Override
    public int getDefaultColorId(ColorModel cm) {
        ColorSpace cs = cm.getColorSpace();
        int type = cs.getType();
        int id = -1;
        switch (type) {
            case 6: {
                id = 1;
                break;
            }
            case 5: {
                id = cm.hasAlpha() ? 6 : 2;
            }
            case 3: {
                try {
                    if (cs == ColorSpace.getInstance(1002)) {
                        id = cm.hasAlpha() ? 10 : 5;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (id != -1) break;
                id = cm.hasAlpha() ? 7 : 3;
                break;
            }
            case 9: {
                id = 4;
                break;
            }
            default: {
                id = 0;
            }
        }
        return id;
    }
}

