; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

define i32 @ctpop_bitreverse(i32 %x) {
; CHECK-LABEL: @ctpop_bitreverse(
; CHECK-NEXT:    [[B:%.*]] = tail call range(i32 0, 33) i32 @llvm.ctpop.i32(i32 [[X:%.*]])
; CHECK-NEXT:    ret i32 [[B]]
;
  %a = tail call i32 @llvm.bitreverse.i32(i32 %x)
  %b = tail call i32 @llvm.ctpop.i32(i32 %a)
  ret i32 %b
}

define <2 x i64> @ctpop_bitreverse_vec(<2 x i64> %x) {
; CHECK-LABEL: @ctpop_bitreverse_vec(
; CHECK-NEXT:    [[B:%.*]] = tail call range(i64 0, 65) <2 x i64> @llvm.ctpop.v2i64(<2 x i64> [[X:%.*]])
; CHECK-NEXT:    ret <2 x i64> [[B]]
;
  %a = tail call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> %x)
  %b = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
  ret <2 x i64> %b
}

define i32 @ctpop_bswap(i32 %x) {
; CHECK-LABEL: @ctpop_bswap(
; CHECK-NEXT:    [[B:%.*]] = tail call range(i32 0, 33) i32 @llvm.ctpop.i32(i32 [[X:%.*]])
; CHECK-NEXT:    ret i32 [[B]]
;
  %a = tail call i32 @llvm.bswap.i32(i32 %x)
  %b = tail call i32 @llvm.ctpop.i32(i32 %a)
  ret i32 %b
}

define <2 x i64> @ctpop_bswap_vec(<2 x i64> %x) {
; CHECK-LABEL: @ctpop_bswap_vec(
; CHECK-NEXT:    [[B:%.*]] = tail call range(i64 0, 65) <2 x i64> @llvm.ctpop.v2i64(<2 x i64> [[X:%.*]])
; CHECK-NEXT:    ret <2 x i64> [[B]]
;
  %a = tail call <2 x i64> @llvm.bswap.v2i64(<2 x i64> %x)
  %b = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
  ret <2 x i64> %b
}

declare i32 @llvm.bitreverse.i32(i32)
declare <2 x i64> @llvm.bitreverse.v2i64(<2 x i64>)
declare i32 @llvm.bswap.i32(i32)
declare <2 x i64> @llvm.bswap.v2i64(<2 x i64>)
declare i32 @llvm.ctpop.i32(i32)
declare <2 x i64> @llvm.ctpop.v2i64(<2 x i64>)
