/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.util.List;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentResultSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedComponentVisitor;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class ThisBuildTreeOnlyComponentResultSerializer
implements ComponentResultSerializer {
    private final Long2ObjectMap<ComponentGraphResolveState> components = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final Long2ObjectMap<VariantGraphResolveState> variants = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final ComponentSelectionReasonSerializer reasonSerializer;

    public ThisBuildTreeOnlyComponentResultSerializer(ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory) {
        this.reasonSerializer = new ComponentSelectionReasonSerializer(componentSelectionDescriptorFactory);
    }

    @Override
    public void writeComponentResult(Encoder encoder, ResolvedGraphComponent value, boolean includeAllSelectableVariantResults) throws Exception {
        encoder.writeSmallLong(value.getResultId());
        this.reasonSerializer.write(encoder, value.getSelectionReason());
        encoder.writeNullableString((CharSequence)value.getRepositoryName());
        ComponentGraphResolveState componentState = value.getResolveState();
        this.writeComponentReference(encoder, componentState);
        encoder.writeBoolean(includeAllSelectableVariantResults);
        List<ResolvedGraphVariant> selectedVariants = value.getSelectedVariants();
        encoder.writeSmallInt(selectedVariants.size());
        for (ResolvedGraphVariant variant : selectedVariants) {
            this.writeVariantResult(variant, encoder);
        }
    }

    private void writeComponentReference(Encoder encoder, ComponentGraphResolveState componentState) throws IOException {
        long instanceId = componentState.getInstanceId();
        this.components.putIfAbsent(instanceId, (Object)componentState);
        encoder.writeSmallLong(instanceId);
    }

    private void writeVariantResult(ResolvedGraphVariant variant, Encoder encoder) throws Exception {
        encoder.writeSmallLong(variant.getNodeId());
        this.writeVariantReference(encoder, variant.getResolveState());
        ResolvedGraphVariant externalVariant = variant.getExternalVariant();
        if (externalVariant != null) {
            encoder.writeBoolean(true);
            this.writeComponentReference(encoder, externalVariant.getComponentResolveState());
            this.writeVariantReference(encoder, externalVariant.getResolveState());
        } else {
            encoder.writeBoolean(false);
        }
    }

    private void writeVariantReference(Encoder encoder, VariantGraphResolveState variant) throws IOException {
        long instanceId = variant.getInstanceId();
        this.variants.putIfAbsent(instanceId, (Object)variant);
        encoder.writeSmallLong(instanceId);
    }

    @Override
    public void readComponentResult(Decoder decoder, ResolvedComponentVisitor visitor) throws Exception {
        long resultId = decoder.readSmallLong();
        ComponentSelectionReason reason = this.reasonSerializer.read(decoder);
        String repo = decoder.readNullableString();
        visitor.startVisitComponent(resultId, reason, repo);
        ComponentGraphResolveState component = this.readComponentReference(decoder);
        visitor.visitComponentDetails(component.getId(), component.getMetadata().getModuleVersionId());
        boolean includeAllSelectableVariantResults = decoder.readBoolean();
        if (includeAllSelectableVariantResults) {
            visitor.visitComponentVariants(component.getAllSelectableVariantResults());
        } else {
            visitor.visitComponentVariants((List<ResolvedVariantResult>)ImmutableList.of());
        }
        int variantCount = decoder.readSmallInt();
        for (int i = 0; i < variantCount; ++i) {
            this.readVariantResult(decoder, component, visitor);
        }
        visitor.endVisitComponent();
    }

    private ComponentGraphResolveState readComponentReference(Decoder decoder) throws IOException {
        long instanceId = decoder.readSmallLong();
        ComponentGraphResolveState component = (ComponentGraphResolveState)this.components.get(instanceId);
        if (component == null) {
            throw new IllegalStateException("No component with id " + instanceId + " found.");
        }
        return component;
    }

    private void readVariantResult(Decoder decoder, ComponentGraphResolveState component, ResolvedComponentVisitor visitor) throws Exception {
        ResolvedVariantResult externalVariant;
        long nodeId = decoder.readSmallLong();
        VariantGraphResolveState variant = this.readVariantReference(decoder);
        if (decoder.readBoolean()) {
            ComponentGraphResolveState externalVariantComponent = this.readComponentReference(decoder);
            VariantGraphResolveState externalVariantReference = this.readVariantReference(decoder);
            externalVariant = externalVariantComponent.getPublicViewFor(externalVariantReference, null);
        } else {
            externalVariant = null;
        }
        ResolvedVariantResult variantResult = component.getPublicViewFor(variant, externalVariant);
        visitor.visitSelectedVariant(nodeId, variantResult);
    }

    private VariantGraphResolveState readVariantReference(Decoder decoder) throws IOException {
        long instanceId = decoder.readSmallLong();
        VariantGraphResolveState variant = (VariantGraphResolveState)this.variants.get(instanceId);
        if (variant == null) {
            throw new IllegalStateException("No variant with id " + instanceId + " found.");
        }
        return variant;
    }
}

