/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.function.Function;
import org.gradle.BuildListener;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.NoOpBuildEventConsumer;
import org.gradle.initialization.RunNestedBuildBuildOperationType;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildLifecycleControllerFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.NestedRootBuild;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeModelControllerServices;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.BuildTreeWorkExecutor;
import org.gradle.internal.buildtree.DefaultBuildTreeLifecycleController;
import org.gradle.internal.buildtree.DefaultBuildTreeWorkExecutor;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.session.BuildSessionState;
import org.gradle.internal.session.CrossBuildSessionState;
import org.gradle.internal.time.Time;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;

public class RootOfNestedBuildTree
extends AbstractBuildState
implements NestedRootBuild {
    private final BuildIdentifier buildIdentifier;
    private final Path identityPath;
    private final BuildState owner;
    private final BuildLifecycleController buildLifecycleController;
    private String buildName;
    private final BuildSessionState session;
    private final BuildTreeState buildTree;
    private final BuildScopeServices buildServices;

    public RootOfNestedBuildTree(BuildDefinition buildDefinition, BuildIdentifier buildIdentifier, Path identityPath, BuildState owner, GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry, CrossBuildSessionState crossBuildSessionState, BuildCancellationToken buildCancellationToken) {
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.owner = owner;
        this.buildName = buildDefinition.getName() == null ? buildIdentifier.getName() : buildDefinition.getName();
        StartParameterInternal startParameter = buildDefinition.getStartParameter();
        DefaultBuildRequestMetaData buildRequestMetaData = new DefaultBuildRequestMetaData(Time.currentTimeMillis());
        this.session = new BuildSessionState(userHomeDirServiceRegistry, crossBuildSessionState, startParameter, (BuildRequestMetaData)buildRequestMetaData, ClassPath.EMPTY, buildCancellationToken, buildRequestMetaData.getClient(), (BuildEventConsumer)new NoOpBuildEventConsumer());
        BuildTreeModelControllerServices.Supplier modelServices = ((BuildTreeModelControllerServices)this.session.getServices().get(BuildTreeModelControllerServices.class)).servicesForNestedBuildTree(startParameter);
        this.buildTree = new BuildTreeState(this.session.getServices(), modelServices);
        BuildLifecycleControllerFactory buildLifecycleControllerFactory = (BuildLifecycleControllerFactory)this.buildTree.getServices().get(BuildLifecycleControllerFactory.class);
        this.buildServices = new BuildScopeServices(this.buildTree.getServices());
        this.buildLifecycleController = buildLifecycleControllerFactory.newInstance(buildDefinition, (BuildState)this, owner.getMutableModel(), this.buildServices);
    }

    public void attach() {
        ((BuildStateRegistry)this.buildServices.get(BuildStateRegistry.class)).attachRootBuild((RootBuildState)this);
    }

    protected ProjectStateRegistry getProjectStateRegistry() {
        return (ProjectStateRegistry)this.buildServices.get(ProjectStateRegistry.class);
    }

    public StartParameterInternal getStartParameter() {
        return this.buildLifecycleController.getGradle().getStartParameter();
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    public boolean isImplicitBuild() {
        return false;
    }

    public SettingsInternal getLoadedSettings() {
        return this.buildLifecycleController.getGradle().getSettings();
    }

    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return this.owner.getCurrentPrefixForProjectsInChildBuilds().child(this.buildName);
    }

    public Path getIdentityPathForProject(Path projectPath) {
        return this.buildLifecycleController.getGradle().getIdentityPath().append(projectPath);
    }

    public File getBuildRootDir() {
        return ((BuildLayout)this.buildLifecycleController.getGradle().getServices().get(BuildLayout.class)).getRootDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(final Function<? super BuildTreeLifecycleController, T> action) {
        Object object;
        try {
            final GradleInternal gradle = this.buildLifecycleController.getGradle();
            BuildOperationExecutor executor = (BuildOperationExecutor)gradle.getServices().get(BuildOperationExecutor.class);
            IncludedBuildControllers controllers = (IncludedBuildControllers)gradle.getServices().get(IncludedBuildControllers.class);
            WorkerLeaseService workerLeaseService = (WorkerLeaseService)gradle.getServices().get(WorkerLeaseService.class);
            ExceptionAnalyser exceptionAnalyser = (ExceptionAnalyser)gradle.getServices().get(ExceptionAnalyser.class);
            DefaultBuildTreeWorkExecutor buildTreeWorkExecutor = new DefaultBuildTreeWorkExecutor(controllers, this.buildLifecycleController);
            final DefaultBuildTreeLifecycleController buildController = new DefaultBuildTreeLifecycleController(this.buildLifecycleController, workerLeaseService, (BuildTreeWorkExecutor)buildTreeWorkExecutor, controllers, exceptionAnalyser);
            object = executor.call(new CallableBuildOperation<T>(){

                public T call(BuildOperationContext context) {
                    gradle.addBuildListener((BuildListener)new InternalBuildAdapter(){

                        public void settingsEvaluated(Settings settings) {
                            RootOfNestedBuildTree.this.buildName = settings.getRootProject().getName();
                        }
                    });
                    Object result = action.apply(buildController);
                    context.setResult((Object)new RunNestedBuildBuildOperationType.Result(){});
                    return result;
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)"Run nested build").details((Object)new RunNestedBuildBuildOperationType.Details(){

                        public String getBuildPath() {
                            return gradle.getIdentityPath().getPath();
                        }
                    });
                }
            });
        }
        catch (Throwable throwable) {
            CompositeStoppable.stoppable((Object[])new Object[]{this.buildLifecycleController, this.buildTree, this.session}).stop();
            throw throwable;
        }
        CompositeStoppable.stoppable((Object[])new Object[]{this.buildLifecycleController, this.buildTree, this.session}).stop();
        return (T)object;
    }

    public GradleInternal getBuild() {
        return this.buildLifecycleController.getGradle();
    }

    public GradleInternal getMutableModel() {
        return this.buildLifecycleController.getGradle();
    }
}

