/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.component.BuildableJavaComponent;
import org.gradle.api.internal.component.ComponentRegistry;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.plugins.jvm.internal.OutgoingElementsBuilder;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.component.local.model.OpaqueComponentIdentifier;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.execution.BuildOutputCleanupRegistry;
import org.gradle.language.jvm.tasks.ProcessResources;

public class JavaPlugin
implements Plugin<Project> {
    public static final String PROCESS_RESOURCES_TASK_NAME = "processResources";
    public static final String CLASSES_TASK_NAME = "classes";
    public static final String COMPILE_JAVA_TASK_NAME = "compileJava";
    public static final String PROCESS_TEST_RESOURCES_TASK_NAME = "processTestResources";
    public static final String TEST_CLASSES_TASK_NAME = "testClasses";
    public static final String COMPILE_TEST_JAVA_TASK_NAME = "compileTestJava";
    public static final String TEST_TASK_NAME = "test";
    public static final String JAR_TASK_NAME = "jar";
    public static final String JAVADOC_TASK_NAME = "javadoc";
    public static final String API_CONFIGURATION_NAME = "api";
    public static final String IMPLEMENTATION_CONFIGURATION_NAME = "implementation";
    public static final String API_ELEMENTS_CONFIGURATION_NAME = "apiElements";
    public static final String COMPILE_ONLY_CONFIGURATION_NAME = "compileOnly";
    public static final String COMPILE_ONLY_API_CONFIGURATION_NAME = "compileOnlyApi";
    public static final String RUNTIME_ONLY_CONFIGURATION_NAME = "runtimeOnly";
    public static final String RUNTIME_CLASSPATH_CONFIGURATION_NAME = "runtimeClasspath";
    public static final String RUNTIME_ELEMENTS_CONFIGURATION_NAME = "runtimeElements";
    public static final String JAVADOC_ELEMENTS_CONFIGURATION_NAME = "javadocElements";
    public static final String SOURCES_ELEMENTS_CONFIGURATION_NAME = "sourcesElements";
    public static final String COMPILE_CLASSPATH_CONFIGURATION_NAME = "compileClasspath";
    public static final String ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "annotationProcessor";
    public static final String TEST_IMPLEMENTATION_CONFIGURATION_NAME = "testImplementation";
    public static final String TEST_COMPILE_ONLY_CONFIGURATION_NAME = "testCompileOnly";
    public static final String TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "testRuntimeOnly";
    public static final String TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME = "testCompileClasspath";
    public static final String TEST_ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "testAnnotationProcessor";
    public static final String TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "testRuntimeClasspath";
    private final ObjectFactory objectFactory;
    private final SoftwareComponentFactory softwareComponentFactory;
    private final JvmPluginServices jvmServices;

    @Inject
    public JavaPlugin(ObjectFactory objectFactory, SoftwareComponentFactory softwareComponentFactory, JvmPluginServices jvmServices) {
        this.objectFactory = objectFactory;
        this.softwareComponentFactory = softwareComponentFactory;
        this.jvmServices = jvmServices;
    }

    public void apply(Project project) {
        if (project.getPluginManager().hasPlugin("java-platform")) {
            throw new IllegalStateException("The \"java\" or \"java-library\" plugin cannot be applied together with the \"java-platform\" plugin. A project is either a platform or a library but cannot be both at the same time.");
        }
        ProjectInternal projectInternal = (ProjectInternal)project;
        project.getPluginManager().apply(JavaBasePlugin.class);
        JavaPluginExtension javaExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        ((ComponentRegistry)projectInternal.getServices().get(ComponentRegistry.class)).setMainComponent((BuildableJavaComponent)new BuildableJavaComponentImpl(project, javaExtension));
        BuildOutputCleanupRegistry buildOutputCleanupRegistry = (BuildOutputCleanupRegistry)projectInternal.getServices().get(BuildOutputCleanupRegistry.class);
        this.configureSourceSets(project, javaExtension, buildOutputCleanupRegistry);
        this.configureConfigurations(project, javaExtension);
        this.configureTest(project, javaExtension);
        this.configureJavadocTask(project, javaExtension);
        this.configureArchivesAndComponent(project, javaExtension);
        this.configureBuild(project);
    }

    private void configureSourceSets(Project project, JavaPluginExtension pluginExtension, BuildOutputCleanupRegistry buildOutputCleanupRegistry) {
        SourceSetContainer sourceSets = pluginExtension.getSourceSets();
        SourceSet main = (SourceSet)sourceSets.create("main");
        SourceSet test = (SourceSet)sourceSets.create(TEST_TASK_NAME);
        test.setCompileClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{main.getOutput(), project.getConfigurations().getByName(TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME)}));
        test.setRuntimeClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{test.getOutput(), main.getOutput(), project.getConfigurations().getByName(TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME)}));
        sourceSets.all(sourceSet -> buildOutputCleanupRegistry.registerOutputs((Object)sourceSet.getOutput()));
    }

    private void configureArchivesAndComponent(Project project, JavaPluginExtension pluginExtension) {
        LazyPublishArtifact jarArtifact = new LazyPublishArtifact(this.registerJarTaskFor(project, pluginExtension));
        Configuration apiElementConfiguration = project.getConfigurations().getByName(API_ELEMENTS_CONFIGURATION_NAME);
        Configuration runtimeElementsConfiguration = project.getConfigurations().getByName(RUNTIME_ELEMENTS_CONFIGURATION_NAME);
        ((DefaultArtifactPublicationSet)project.getExtensions().getByType(DefaultArtifactPublicationSet.class)).addCandidate((PublishArtifact)jarArtifact);
        TaskProvider processResources = project.getTasks().named(PROCESS_RESOURCES_TASK_NAME, ProcessResources.class);
        this.addJar(apiElementConfiguration, (PublishArtifact)jarArtifact);
        this.addRuntimeVariants(runtimeElementsConfiguration, (PublishArtifact)jarArtifact, JavaPlugin.mainSourceSetOf(pluginExtension), (Provider<ProcessResources>)processResources);
        this.registerSoftwareComponents(project);
    }

    private TaskProvider<Jar> registerJarTaskFor(Project project, JavaPluginExtension pluginExtension) {
        return project.getTasks().register(JAR_TASK_NAME, Jar.class, jar -> {
            jar.setDescription("Assembles a jar archive containing the main classes.");
            jar.setGroup("build");
            jar.from(new Object[]{JavaPlugin.mainSourceSetOf(pluginExtension).getOutput()});
        });
    }

    private static SourceSet mainSourceSetOf(JavaPluginExtension pluginExtension) {
        return JavaPlugin.sourceSetOf(pluginExtension, "main");
    }

    private static SourceSet sourceSetOf(JavaPluginExtension pluginExtension, String mainSourceSetName) {
        return (SourceSet)pluginExtension.getSourceSets().getByName(mainSourceSetName);
    }

    private void configureJavadocTask(Project project, JavaPluginExtension javaPluginExtension) {
        SourceSet main = JavaPlugin.mainSourceSetOf(javaPluginExtension);
        JvmPluginsHelper.configureJavaDocTask(null, main, project.getTasks(), javaPluginExtension);
    }

    private void registerSoftwareComponents(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        AdhocComponentWithVariants java = this.softwareComponentFactory.adhoc("java");
        java.addVariantsFromConfiguration(configurations.getByName(API_ELEMENTS_CONFIGURATION_NAME), (Action)new JavaConfigurationVariantMapping("compile", false));
        java.addVariantsFromConfiguration(configurations.getByName(RUNTIME_ELEMENTS_CONFIGURATION_NAME), (Action)new JavaConfigurationVariantMapping("runtime", false));
        project.getComponents().add((Object)java);
    }

    private void addJar(Configuration configuration, PublishArtifact jarArtifact) {
        ConfigurationPublications publications = configuration.getOutgoing();
        publications.getArtifacts().add((Object)jarArtifact);
        publications.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)JAR_TASK_NAME);
    }

    private void addRuntimeVariants(Configuration configuration, PublishArtifact jarArtifact, SourceSet sourceSet, final Provider<ProcessResources> processResources) {
        ConfigurationPublications publications = configuration.getOutgoing();
        publications.getArtifacts().add((Object)jarArtifact);
        publications.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)JAR_TASK_NAME);
        this.jvmServices.configureClassesDirectoryVariant(sourceSet.getRuntimeElementsConfigurationName(), sourceSet);
        NamedDomainObjectContainer runtimeVariants = publications.getVariants();
        ConfigurationVariant resourcesVariant = (ConfigurationVariant)runtimeVariants.create("resources");
        resourcesVariant.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.objectFactory.named(Usage.class, "java-runtime")));
        resourcesVariant.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.objectFactory.named(LibraryElements.class, "resources")));
        resourcesVariant.artifact((Object)new JvmPluginsHelper.IntermediateJavaArtifact("java-resources-directory", processResources){

            public File getFile() {
                return ((ProcessResources)processResources.get()).getDestinationDir();
            }
        });
    }

    private void configureBuild(Project project) {
        project.getTasks().named("buildNeeded", task -> this.addDependsOnTaskInOtherProjects((Task)task, true, "buildNeeded", TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME));
        project.getTasks().named("buildDependents", task -> this.addDependsOnTaskInOtherProjects((Task)task, false, "buildDependents", TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME));
    }

    private void configureTest(Project project, JavaPluginExtension javaPluginExtension) {
        project.getTasks().withType(Test.class).configureEach(test -> {
            test.getConventionMapping().map("testClassesDirs", () -> JavaPlugin.sourceSetOf(javaPluginExtension, TEST_TASK_NAME).getOutput().getClassesDirs());
            test.getConventionMapping().map("classpath", () -> JavaPlugin.sourceSetOf(javaPluginExtension, TEST_TASK_NAME).getRuntimeClasspath());
            test.getModularity().getInferModulePath().convention((Provider)javaPluginExtension.getModularity().getInferModulePath());
        });
        TaskProvider test2 = project.getTasks().register(TEST_TASK_NAME, Test.class, test1 -> {
            test1.setDescription("Runs the unit tests.");
            test1.setGroup("verification");
        });
        project.getTasks().named("check", arg_0 -> JavaPlugin.lambda$configureTest$8((Provider)test2, arg_0));
    }

    private void configureConfigurations(Project project, JavaPluginExtension extension) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration defaultConfiguration = configurations.getByName("default");
        Configuration implementationConfiguration = configurations.getByName(IMPLEMENTATION_CONFIGURATION_NAME);
        Configuration runtimeOnlyConfiguration = configurations.getByName(RUNTIME_ONLY_CONFIGURATION_NAME);
        Configuration testImplementationConfiguration = configurations.getByName(TEST_IMPLEMENTATION_CONFIGURATION_NAME);
        Configuration testRuntimeOnlyConfiguration = configurations.getByName(TEST_RUNTIME_ONLY_CONFIGURATION_NAME);
        testImplementationConfiguration.extendsFrom(new Configuration[]{implementationConfiguration});
        testRuntimeOnlyConfiguration.extendsFrom(new Configuration[]{runtimeOnlyConfiguration});
        SourceSet main = (SourceSet)extension.getSourceSets().getByName("main");
        DeprecatableConfiguration apiElementsConfiguration = (DeprecatableConfiguration)this.jvmServices.createOutgoingElements(API_ELEMENTS_CONFIGURATION_NAME, (Action<? super OutgoingElementsBuilder>)((Action)builder -> builder.fromSourceSet(main).providesApi().withDescription("API elements for main.")));
        DeprecatableConfiguration runtimeElementsConfiguration = (DeprecatableConfiguration)this.jvmServices.createOutgoingElements(RUNTIME_ELEMENTS_CONFIGURATION_NAME, (Action<? super OutgoingElementsBuilder>)((Action)builder -> builder.fromSourceSet(main).providesRuntime().withDescription("Elements of runtime for main.").extendsFrom(implementationConfiguration, runtimeOnlyConfiguration)));
        defaultConfiguration.extendsFrom(new Configuration[]{runtimeElementsConfiguration});
        apiElementsConfiguration.deprecateForDeclaration(new String[]{IMPLEMENTATION_CONFIGURATION_NAME, COMPILE_ONLY_CONFIGURATION_NAME});
        runtimeElementsConfiguration.deprecateForDeclaration(new String[]{IMPLEMENTATION_CONFIGURATION_NAME, COMPILE_ONLY_CONFIGURATION_NAME, RUNTIME_ONLY_CONFIGURATION_NAME});
    }

    private void addDependsOnTaskInOtherProjects(Task task, boolean useDependedOn, String otherProjectTaskName, String configurationName) {
        Project project = task.getProject();
        Configuration configuration = project.getConfigurations().getByName(configurationName);
        task.dependsOn(new Object[]{configuration.getTaskDependencyFromProjectDependency(useDependedOn, otherProjectTaskName)});
    }

    private static /* synthetic */ void lambda$configureTest$8(Provider test, Task task) {
        task.dependsOn(new Object[]{test});
    }

    private static class BuildableJavaComponentImpl
    implements BuildableJavaComponent {
        private final Project project;
        private final JavaPluginExtension extension;

        public BuildableJavaComponentImpl(Project project, JavaPluginExtension extension) {
            this.project = project;
            this.extension = extension;
        }

        public Collection<String> getBuildTasks() {
            return Collections.singleton("build");
        }

        public FileCollection getRuntimeClasspath() {
            SourceSet mainSourceSet = JavaPlugin.mainSourceSetOf(this.extension);
            Configuration runtimeClasspath = this.project.getConfigurations().getByName(mainSourceSet.getRuntimeClasspathConfigurationName());
            ArtifactView view = runtimeClasspath.getIncoming().artifactView(config -> config.componentFilter(componentId -> {
                if (componentId instanceof OpaqueComponentIdentifier) {
                    DependencyFactory.ClassPathNotation classPathNotation = ((OpaqueComponentIdentifier)componentId).getClassPathNotation();
                    return classPathNotation != DependencyFactory.ClassPathNotation.GRADLE_API && classPathNotation != DependencyFactory.ClassPathNotation.LOCAL_GROOVY;
                }
                return true;
            }));
            Configuration runtimeElements = this.project.getConfigurations().getByName(mainSourceSet.getRuntimeElementsConfigurationName());
            return runtimeElements.getOutgoing().getArtifacts().getFiles().plus(view.getFiles());
        }

        public Configuration getCompileDependencies() {
            return this.project.getConfigurations().getByName(JavaPlugin.COMPILE_CLASSPATH_CONFIGURATION_NAME);
        }
    }
}

