/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.compile.MinimalGroovyCompilerDaemonForkOptions;
import org.gradle.api.tasks.compile.GroovyCompileOptions;

public class MinimalGroovyCompileOptions
implements Serializable {
    private boolean failOnError;
    private boolean verbose;
    private boolean listFiles;
    private String encoding;
    private boolean fork = true;
    private boolean keepStubs;
    private List<String> fileExtensions;
    private MinimalGroovyCompilerDaemonForkOptions forkOptions;
    private Map<String, Boolean> optimizationOptions;
    private File stubDir;
    private File configurationScript;
    private boolean javaAnnotationProcessing;
    private boolean parameters;

    public MinimalGroovyCompileOptions(GroovyCompileOptions compileOptions) {
        this.failOnError = compileOptions.isFailOnError();
        this.verbose = compileOptions.isVerbose();
        this.listFiles = compileOptions.isListFiles();
        this.encoding = compileOptions.getEncoding();
        this.fork = compileOptions.isFork();
        this.keepStubs = compileOptions.isKeepStubs();
        this.fileExtensions = ImmutableList.copyOf(compileOptions.getFileExtensions());
        this.forkOptions = new MinimalGroovyCompilerDaemonForkOptions(compileOptions.getForkOptions());
        this.optimizationOptions = Maps.newHashMap(compileOptions.getOptimizationOptions());
        this.stubDir = compileOptions.getStubDir();
        this.configurationScript = compileOptions.getConfigurationScript();
        this.javaAnnotationProcessing = compileOptions.isJavaAnnotationProcessing();
        this.parameters = compileOptions.isParameters();
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isListFiles() {
        return this.listFiles;
    }

    public void setListFiles(boolean listFiles) {
        this.listFiles = listFiles;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public boolean isKeepStubs() {
        return this.keepStubs;
    }

    public void setKeepStubs(boolean keepStubs) {
        this.keepStubs = keepStubs;
    }

    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(List<String> fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public MinimalGroovyCompilerDaemonForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public void setForkOptions(MinimalGroovyCompilerDaemonForkOptions forkOptions) {
        this.forkOptions = forkOptions;
    }

    @Nullable
    public Map<String, Boolean> getOptimizationOptions() {
        return this.optimizationOptions;
    }

    public void setOptimizationOptions(@Nullable Map<String, Boolean> optimizationOptions) {
        this.optimizationOptions = optimizationOptions;
    }

    public File getStubDir() {
        return this.stubDir;
    }

    public void setStubDir(File stubDir) {
        this.stubDir = stubDir;
    }

    @Nullable
    public File getConfigurationScript() {
        return this.configurationScript;
    }

    public void setConfigurationScript(@Nullable File configurationScript) {
        this.configurationScript = configurationScript;
    }

    public boolean isJavaAnnotationProcessing() {
        return this.javaAnnotationProcessing;
    }

    public void setJavaAnnotationProcessing(boolean javaAnnotationProcessing) {
        this.javaAnnotationProcessing = javaAnnotationProcessing;
    }

    public boolean isParameters() {
        return this.parameters;
    }

    public void setParameters(boolean parameters) {
        this.parameters = parameters;
    }
}

