/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;

public class WellKnownSourceFileClassNameConverter
implements SourceFileClassNameConverter {
    private final SourceFileClassNameConverter delegate;
    private final String fileExtension;

    public WellKnownSourceFileClassNameConverter(SourceFileClassNameConverter delegate, String fileExtension) {
        this.delegate = delegate;
        this.fileExtension = fileExtension;
    }

    @Override
    public Collection<String> getClassNames(String sourceFileRelativePath) {
        String withoutExtension = StringUtils.removeEnd((String)sourceFileRelativePath, (String)this.fileExtension);
        if (withoutExtension.endsWith("module-info")) {
            return Collections.singleton("module-info");
        }
        if (withoutExtension.endsWith("package-info")) {
            String packageName = withoutExtension.replace('/', '.');
            return Collections.singleton(packageName);
        }
        return this.delegate.getClassNames(sourceFileRelativePath);
    }

    @Override
    public Collection<String> getRelativeSourcePaths(String className) {
        if (className.equals("module-info") || className.endsWith("package-info")) {
            return Collections.singleton(className.replace('.', '/') + this.fileExtension);
        }
        return this.delegate.getRelativeSourcePaths(className);
    }
}

