/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;

public class DefaultSourceFileClassNameConverter
implements SourceFileClassNameConverter {
    private final Map<String, Set<String>> sourceClassesMapping;
    private final Map<String, Set<String>> classSourceMapping;

    public DefaultSourceFileClassNameConverter(Map<String, Set<String>> sourceClassesMapping) {
        this.sourceClassesMapping = sourceClassesMapping;
        this.classSourceMapping = this.constructReverseMapping(sourceClassesMapping);
    }

    private Map<String, Set<String>> constructReverseMapping(Map<String, Set<String>> sourceClassesMapping) {
        HashMap<String, Set<String>> reverse = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : sourceClassesMapping.entrySet()) {
            for (String cls : (Collection)entry.getValue()) {
                reverse.computeIfAbsent(cls, key -> new HashSet()).add(entry.getKey());
            }
        }
        return reverse;
    }

    @Override
    public Collection<String> getClassNames(String sourceFileRelativePath) {
        return this.sourceClassesMapping.getOrDefault(sourceFileRelativePath, Collections.emptySet());
    }

    @Override
    public Collection<String> getRelativeSourcePaths(String fqcn) {
        return this.classSourceMapping.getOrDefault(fqcn, Collections.emptySet());
    }
}

