/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtClassElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J5\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\u001cJ\u0006\u0010 \u001a\u00020\u001cJ\u0006\u0010!\u001a\u00020\u001cJ\u0006\u0010\"\u001a\u00020\u001cR\u0016\u0010\b\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/psi/KtClass;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;)V", "_stub", "get_stub", "()Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getClassKeyword", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getClassOrInterfaceKeyword", "getCompanionObjects", "", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "getFunKeyword", "getProperties", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isData", "", "isEnum", "isInline", "isInner", "isInterface", "isSealed", "isValue", "psi"})
public class KtClass
extends KtClassOrObject {
    public KtClass(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    public KtClass(@NotNull KotlinClassStub stub) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub;
        KtClassElementType ktClassElementType = KtStubElementTypes.CLASS;
        Intrinsics.checkNotNullExpressionValue((Object)ktClassElementType, (String)"CLASS");
        super(kotlinClassOrObjectStub, (IStubElementType)ktClassElementType);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visitClass(this, data);
    }

    private final KotlinClassStub get_stub() {
        Object t = this.getStub();
        return t instanceof KotlinClassStub ? (KotlinClassStub)t : null;
    }

    @NotNull
    public final List<KtProperty> getProperties() {
        Object object = this.getBody();
        object = object == null ? null : ((KtClassBody)object).getProperties();
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        return object2;
    }

    public final boolean isInterface() {
        Boolean bl;
        KotlinClassStub kotlinClassStub = this.get_stub();
        Boolean bl2 = bl = kotlinClassStub == null ? null : Boolean.valueOf(kotlinClassStub.isInterface());
        return bl == null ? this.findChildByType(KtTokens.INTERFACE_KEYWORD) != null : bl;
    }

    public final boolean isEnum() {
        return this.hasModifier(KtTokens.ENUM_KEYWORD);
    }

    public final boolean isData() {
        return this.hasModifier(KtTokens.DATA_KEYWORD);
    }

    public final boolean isSealed() {
        return this.hasModifier(KtTokens.SEALED_KEYWORD);
    }

    public final boolean isInner() {
        return this.hasModifier(KtTokens.INNER_KEYWORD);
    }

    public final boolean isInline() {
        return this.hasModifier(KtTokens.INLINE_KEYWORD);
    }

    public final boolean isValue() {
        return this.hasModifier(KtTokens.VALUE_KEYWORD);
    }

    @Override
    @NotNull
    public List<KtObjectDeclaration> getCompanionObjects() {
        Object object = this.getBody();
        object = object == null ? null : ((KtClassBody)object).getAllCompanionObjects();
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        return object2;
    }

    @Nullable
    public final PsiElement getClassOrInterfaceKeyword() {
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        return this.findChildByType(TokenSet.create(iElementTypeArray));
    }

    @Nullable
    public final PsiElement getClassKeyword() {
        return this.findChildByType(KtTokens.CLASS_KEYWORD);
    }

    @Nullable
    public final PsiElement getFunKeyword() {
        KtModifierList ktModifierList = this.getModifierList();
        return ktModifierList == null ? null : ktModifierList.getModifier(KtTokens.FUN_KEYWORD);
    }
}

