/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.Closeable;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.PersistentStateCache;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationStateCacheFactory;
import org.gradle.language.nativeplatform.internal.incremental.CompilationStateSerializer;

@ServiceScope(value=Scopes.Gradle.class)
public class DefaultCompilationStateCacheFactory
implements CompilationStateCacheFactory,
Closeable {
    private final PersistentIndexedCache<String, CompilationState> compilationStateIndexedCache;
    private final PersistentCache cache;

    public DefaultCompilationStateCacheFactory(CacheRepository cacheRepository, Gradle gradle, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        this.cache = cacheRepository.cache((Object)gradle, "nativeCompile").withDisplayName("native compile cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).open();
        PersistentIndexedCacheParameters parameters = PersistentIndexedCacheParameters.of((String)"nativeCompile", String.class, (Serializer)new CompilationStateSerializer()).withCacheDecorator(inMemoryCacheDecoratorFactory.decorator(2000, false));
        this.compilationStateIndexedCache = this.cache.createCache(parameters);
    }

    @Override
    public void close() {
        this.cache.close();
    }

    @Override
    public PersistentStateCache<CompilationState> create(String taskPath) {
        return new PersistentCompilationStateCache(taskPath, this.compilationStateIndexedCache);
    }

    private static class PersistentCompilationStateCache
    implements PersistentStateCache<CompilationState> {
        private final String taskPath;
        private final PersistentIndexedCache<String, CompilationState> compilationStateIndexedCache;

        PersistentCompilationStateCache(String taskPath, PersistentIndexedCache<String, CompilationState> compilationStateIndexedCache) {
            this.taskPath = taskPath;
            this.compilationStateIndexedCache = compilationStateIndexedCache;
        }

        public CompilationState get() {
            return (CompilationState)this.compilationStateIndexedCache.getIfPresent((Object)this.taskPath);
        }

        public void set(CompilationState newValue) {
            this.compilationStateIndexedCache.put((Object)this.taskPath, (Object)newValue);
        }

        public CompilationState update(PersistentStateCache.UpdateAction<CompilationState> updateAction) {
            throw new UnsupportedOperationException();
        }

        public CompilationState maybeUpdate(PersistentStateCache.UpdateAction<CompilationState> updateAction) {
            throw new UnsupportedOperationException();
        }
    }
}

