/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.Optional;
import org.gradle.api.internal.changedetection.TaskExecutionMode;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class DefaultTaskExecutionContext
implements TaskExecutionContext {
    private final LocalTaskNode localTaskNode;
    private final TaskProperties properties;
    private final WorkValidationContext validationContext;
    private final TaskExecutionContext.ValidationAction validationAction;
    private TaskExecutionMode taskExecutionMode;
    private Long executionTime;
    private BuildOperationContext snapshotTaskInputsBuildOperationContext;
    private final Timer executionTimer;

    public DefaultTaskExecutionContext(LocalTaskNode localTaskNode, TaskProperties taskProperties, WorkValidationContext validationContext, TaskExecutionContext.ValidationAction validationAction) {
        this.localTaskNode = localTaskNode;
        this.properties = taskProperties;
        this.validationContext = validationContext;
        this.validationAction = validationAction;
        this.executionTimer = Time.startTimer();
    }

    @Override
    public LocalTaskNode getLocalTaskNode() {
        return this.localTaskNode;
    }

    @Override
    public TaskExecutionMode getTaskExecutionMode() {
        return this.taskExecutionMode;
    }

    @Override
    public WorkValidationContext getValidationContext() {
        return this.validationContext;
    }

    @Override
    public TaskExecutionContext.ValidationAction getValidationAction() {
        return this.validationAction;
    }

    @Override
    public void setTaskExecutionMode(TaskExecutionMode taskExecutionMode) {
        this.taskExecutionMode = taskExecutionMode;
    }

    @Override
    public long markExecutionTime() {
        if (this.executionTime != null) {
            throw new IllegalStateException("execution time already set");
        }
        this.executionTime = this.executionTimer.getElapsedMillis();
        return this.executionTime;
    }

    @Override
    public TaskProperties getTaskProperties() {
        return this.properties;
    }

    @Override
    public Optional<BuildOperationContext> removeSnapshotTaskInputsBuildOperationContext() {
        Optional<BuildOperationContext> result = Optional.ofNullable(this.snapshotTaskInputsBuildOperationContext);
        this.snapshotTaskInputsBuildOperationContext = null;
        return result;
    }

    @Override
    public void setSnapshotTaskInputsBuildOperationContext(BuildOperationContext snapshotTaskInputsBuildOperation) {
        this.snapshotTaskInputsBuildOperationContext = snapshotTaskInputsBuildOperation;
    }
}

