/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.tasks;

import java.io.File;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.publish.internal.PublishOperation;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.api.publish.maven.internal.publisher.ValidatingMavenPublisher;
import org.gradle.api.publish.maven.tasks.AbstractPublishToMaven;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Factory;
import org.gradle.internal.serialization.Cached;

public class PublishToMavenLocal
extends AbstractPublishToMaven {
    private final Cached<MavenNormalizedPublication> normalizedPublication = Cached.of(this::computeNormalizedPublication);

    private MavenNormalizedPublication computeNormalizedPublication() {
        MavenPublicationInternal publicationInternal = this.getPublicationInternal();
        if (publicationInternal == null) {
            throw new InvalidUserDataException("The 'publication' property is required");
        }
        this.getDuplicatePublicationTracker().checkCanPublishToMavenLocal(publicationInternal);
        return publicationInternal.asNormalisedPublication();
    }

    @TaskAction
    public void publish() {
        MavenNormalizedPublication normalizedPublication = (MavenNormalizedPublication)this.normalizedPublication.get();
        this.doPublish(normalizedPublication);
    }

    private void doPublish(final MavenNormalizedPublication normalizedPublication) {
        new PublishOperation(normalizedPublication.getName(), "mavenLocal"){

            protected void publish() {
                MavenPublisher localPublisher = PublishToMavenLocal.this.getMavenPublishers().getLocalPublisher((Factory<File>)PublishToMavenLocal.this.getTemporaryDirFactory());
                ValidatingMavenPublisher validatingPublisher = new ValidatingMavenPublisher(localPublisher);
                validatingPublisher.publish(normalizedPublication, null);
            }
        }.run();
    }
}

