/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.wrapper;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.plugins.StartScriptGenerator;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.options.OptionValues;
import org.gradle.internal.util.PropertiesUtils;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.DistributionLocator;
import org.gradle.util.internal.WrapUtil;
import org.gradle.wrapper.GradleWrapperMain;

public class Wrapper
extends DefaultTask {
    public static final String DEFAULT_DISTRIBUTION_PARENT_NAME = "wrapper/dists";
    private Object scriptFile = "gradlew";
    private Object jarFile = "gradle/wrapper/gradle-wrapper.jar";
    private String distributionPath = "wrapper/dists";
    private PathBase distributionBase = PathBase.GRADLE_USER_HOME;
    private String distributionUrl;
    private String distributionSha256Sum;
    private GradleVersion gradleVersion;
    private DistributionType distributionType = DistributionType.BIN;
    private String archivePath = "wrapper/dists";
    private PathBase archiveBase = PathBase.GRADLE_USER_HOME;
    private final DistributionLocator locator = new DistributionLocator();

    public Wrapper() {
        this.gradleVersion = GradleVersion.current();
    }

    @Inject
    protected FileLookup getFileLookup() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    void generate() {
        File jarFileDestination = this.getJarFile();
        File unixScript = this.getScriptFile();
        FileResolver resolver = this.getFileLookup().getFileResolver(unixScript.getParentFile());
        String jarFileRelativePath = resolver.resolveAsRelativePath((Object)jarFileDestination);
        this.writeProperties(this.getPropertiesFile());
        this.writeWrapperTo(jarFileDestination);
        StartScriptGenerator generator = new StartScriptGenerator();
        generator.setApplicationName("Gradle");
        generator.setMainClassName(GradleWrapperMain.class.getName());
        generator.setClasspath((Iterable)WrapUtil.toList((Object[])new String[]{jarFileRelativePath}));
        generator.setOptsEnvironmentVar("GRADLE_OPTS");
        generator.setExitEnvironmentVar("GRADLE_EXIT_CONSOLE");
        generator.setAppNameSystemProperty("org.gradle.appname");
        generator.setScriptRelPath(unixScript.getName());
        generator.setDefaultJvmOpts((Iterable)ImmutableList.of((Object)"-Xmx64m", (Object)"-Xms64m"));
        generator.generateUnixScript(unixScript);
        generator.generateWindowsScript(this.getBatchScript());
    }

    private void writeWrapperTo(File destination) {
        URL jarFileSource = Wrapper.class.getResource("/gradle-wrapper.jar");
        if (jarFileSource == null) {
            throw new GradleException("Cannot locate wrapper JAR resource.");
        }
        try (InputStream in = jarFileSource.openStream();
             FileOutputStream out = new FileOutputStream(destination);){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write wrapper JAR to " + destination, (Throwable)e);
        }
    }

    private void writeProperties(File propertiesFileDestination) {
        Properties wrapperProperties = new Properties();
        wrapperProperties.put("distributionUrl", this.getDistributionUrl());
        if (this.distributionSha256Sum != null) {
            wrapperProperties.put("distributionSha256Sum", this.distributionSha256Sum);
        }
        wrapperProperties.put("distributionBase", this.distributionBase.toString());
        wrapperProperties.put("distributionPath", this.distributionPath);
        wrapperProperties.put("zipStoreBase", this.archiveBase.toString());
        wrapperProperties.put("zipStorePath", this.archivePath);
        try {
            PropertiesUtils.store((Properties)wrapperProperties, (File)propertiesFileDestination);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    @OutputFile
    public File getScriptFile() {
        return ((FileOperations)this.getServices().get(FileOperations.class)).file(this.scriptFile);
    }

    public void setScriptFile(File scriptFile) {
        this.scriptFile = scriptFile;
    }

    public void setScriptFile(Object scriptFile) {
        this.scriptFile = scriptFile;
    }

    @OutputFile
    public File getBatchScript() {
        File scriptFile = this.getScriptFile();
        return new File(scriptFile.getParentFile(), scriptFile.getName().replaceFirst("(\\.[^\\.]+)?$", ".bat"));
    }

    @OutputFile
    public File getJarFile() {
        return ((FileOperations)this.getServices().get(FileOperations.class)).file(this.jarFile);
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    public void setJarFile(Object jarFile) {
        this.jarFile = jarFile;
    }

    @OutputFile
    public File getPropertiesFile() {
        File jarFileDestination = this.getJarFile();
        return new File(jarFileDestination.getParentFile(), jarFileDestination.getName().replaceAll("\\.jar$", ".properties"));
    }

    @Input
    public String getDistributionPath() {
        return this.distributionPath;
    }

    public void setDistributionPath(String distributionPath) {
        this.distributionPath = distributionPath;
    }

    @Input
    public String getGradleVersion() {
        return this.gradleVersion.getVersion();
    }

    @Option(option="gradle-version", description="The version of the Gradle distribution required by the wrapper.")
    public void setGradleVersion(String gradleVersion) {
        this.gradleVersion = GradleVersion.version((String)gradleVersion);
    }

    @Input
    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    @Option(option="distribution-type", description="The type of the Gradle distribution to be used by the wrapper.")
    public void setDistributionType(DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    @OptionValues(value={"distribution-type"})
    public List<DistributionType> getAvailableDistributionTypes() {
        return Arrays.asList(DistributionType.values());
    }

    @Input
    public String getDistributionUrl() {
        if (this.distributionUrl != null) {
            return this.distributionUrl;
        }
        if (this.gradleVersion != null) {
            return this.locator.getDistributionFor(this.gradleVersion, this.distributionType.name().toLowerCase(Locale.ENGLISH)).toString();
        }
        return null;
    }

    @Option(option="gradle-distribution-url", description="The URL to download the Gradle distribution from.")
    public void setDistributionUrl(String url) {
        this.distributionUrl = url;
    }

    @Nullable
    @Optional
    @Input
    public String getDistributionSha256Sum() {
        return this.distributionSha256Sum;
    }

    @Option(option="gradle-distribution-sha256-sum", description="The SHA-256 hash sum of the gradle distribution.")
    public void setDistributionSha256Sum(@Nullable String distributionSha256Sum) {
        this.distributionSha256Sum = distributionSha256Sum;
    }

    @Input
    public PathBase getDistributionBase() {
        return this.distributionBase;
    }

    public void setDistributionBase(PathBase distributionBase) {
        this.distributionBase = distributionBase;
    }

    @Input
    public String getArchivePath() {
        return this.archivePath;
    }

    public void setArchivePath(String archivePath) {
        this.archivePath = archivePath;
    }

    @Input
    public PathBase getArchiveBase() {
        return this.archiveBase;
    }

    public void setArchiveBase(PathBase archiveBase) {
        this.archiveBase = archiveBase;
    }

    public static enum PathBase {
        PROJECT,
        GRADLE_USER_HOME;

    }

    public static enum DistributionType {
        BIN,
        ALL;

    }
}

