// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkCompositeUnsignedLongLongArray
 * @brief   composite implicit array of unsigned long long.
 *
 * vtkCompositeUnsignedLongLongArray is a composite implicit array of values of type unsigned long long.
 * see vtkCompositeArray, vtkCompositeImplicitBackend
 *
 * This file is generated by vtkImplicitArrays.cmake
 */

#ifndef vtkCompositeUnsignedLongLongArray_h
#define vtkCompositeUnsignedLongLongArray_h

#include "vtkCompositeArray.h" // Real Superclass
#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkCompositeArray<unsigned long long>
#endif
VTK_ABI_NAMESPACE_BEGIN
class vtkDataArrayCollection;

class VTKCOMMONCORE_EXPORT vtkCompositeUnsignedLongLongArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkCompositeUnsignedLongLongArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkCompositeUnsignedLongLongArray* New();
  static vtkCompositeUnsignedLongLongArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(unsigned long long);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkCompositeUnsignedLongLongArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkCompositeUnsignedLongLongArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the underlying arrays to use.
   */
  void ConstructBackend(vtkDataArrayCollection* arrays);

protected:
  vtkCompositeUnsignedLongLongArray();
  ~vtkCompositeUnsignedLongLongArray() override;

private:
  typedef vtkCompositeArray<unsigned long long> RealSuperclass;

  vtkCompositeUnsignedLongLongArray(const vtkCompositeUnsignedLongLongArray&) = delete;
  void operator=(const vtkCompositeUnsignedLongLongArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkCompositeUnsignedLongLongArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
