#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetactivepoint_ DMPLEXGETACTIVEPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetactivepoint_ dmplexgetactivepoint
#endif
PETSC_EXTERN void dmplexgetactivepoint_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMPlexGetActivePoint(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetactivepoint_ DMPLEXSETACTIVEPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetactivepoint_ dmplexsetactivepoint
#endif
PETSC_EXTERN void dmplexsetactivepoint_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetActivePoint(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetfirstlabeledpoint_ DMGETFIRSTLABELEDPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetfirstlabeledpoint_ dmgetfirstlabeledpoint
#endif
PETSC_EXTERN void dmgetfirstlabeledpoint_(DM *a, DM *b, DMLabel *c, PetscInt *d, const PetscInt e[], PetscInt *f, PetscInt *g, PetscDS *h, PetscErrorCode *ierr)
{
  PetscBool null_h = !*(void**) h ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLOBJECT(h);
  *ierr = DMGetFirstLabeledPoint(*a, *b, *c, *d, e, *f, g, h);
  if (*ierr) return;
  if (! null_h && !*(void**) h) *(void **) h = (void *)-2;
}
