#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mataxpy_ MATAXPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mataxpy_ mataxpy
#endif
PETSC_EXTERN void mataxpy_(Mat *a, PetscScalar *b, Mat *c, MatStructure *d, PetscErrorCode *ierr)
{
  *ierr = MatAXPY(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matshift_ MATSHIFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matshift_ matshift
#endif
PETSC_EXTERN void matshift_(Mat *a, PetscScalar *b, PetscErrorCode *ierr)
{
  *ierr = MatShift(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdiagonalset_ MATDIAGONALSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdiagonalset_ matdiagonalset
#endif
PETSC_EXTERN void matdiagonalset_(Mat *a, Vec *b, InsertMode *c, PetscErrorCode *ierr)
{
  *ierr = MatDiagonalSet(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mataypx_ MATAYPX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mataypx_ mataypx
#endif
PETSC_EXTERN void mataypx_(Mat *a, PetscScalar *b, Mat *c, MatStructure *d, PetscErrorCode *ierr)
{
  *ierr = MatAYPX(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcomputeoperator_ MATCOMPUTEOPERATOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcomputeoperator_ matcomputeoperator
#endif
PETSC_EXTERN void matcomputeoperator_(Mat *a, char * b, Mat *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatComputeOperator(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcomputeoperatortranspose_ MATCOMPUTEOPERATORTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcomputeoperatortranspose_ matcomputeoperatortranspose
#endif
PETSC_EXTERN void matcomputeoperatortranspose_(Mat *a, char * b, Mat *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatComputeOperatorTranspose(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matfilter_ MATFILTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matfilter_ matfilter
#endif
PETSC_EXTERN void matfilter_(Mat *a, PetscReal *b, PetscBool *c, PetscBool *d, PetscErrorCode *ierr)
{
  *ierr = MatFilter(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
