#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoalmmgettype_ TAOALMMGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoalmmgettype_ taoalmmgettype
#endif
PETSC_EXTERN void taoalmmgettype_(Tao *a, TaoALMMType *b, PetscErrorCode *ierr)
{
  *ierr = TaoALMMGetType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoalmmsettype_ TAOALMMSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoalmmsettype_ taoalmmsettype
#endif
PETSC_EXTERN void taoalmmsettype_(Tao *a, TaoALMMType *b, PetscErrorCode *ierr)
{
  *ierr = TaoALMMSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoalmmgetsubsolver_ TAOALMMGETSUBSOLVER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoalmmgetsubsolver_ taoalmmgetsubsolver
#endif
PETSC_EXTERN void taoalmmgetsubsolver_(Tao *a, Tao *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoALMMGetSubsolver(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoalmmsetsubsolver_ TAOALMMSETSUBSOLVER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoalmmsetsubsolver_ taoalmmsetsubsolver
#endif
PETSC_EXTERN void taoalmmsetsubsolver_(Tao *a, Tao *b, PetscErrorCode *ierr)
{
  *ierr = TaoALMMSetSubsolver(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoalmmgetmultipliers_ TAOALMMGETMULTIPLIERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoalmmgetmultipliers_ taoalmmgetmultipliers
#endif
PETSC_EXTERN void taoalmmgetmultipliers_(Tao *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoALMMGetMultipliers(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoalmmsetmultipliers_ TAOALMMSETMULTIPLIERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoalmmsetmultipliers_ taoalmmsetmultipliers
#endif
PETSC_EXTERN void taoalmmsetmultipliers_(Tao *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = TaoALMMSetMultipliers(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoalmmgetprimalis_ TAOALMMGETPRIMALIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoalmmgetprimalis_ taoalmmgetprimalis
#endif
PETSC_EXTERN void taoalmmgetprimalis_(Tao *a, IS *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = TaoALMMGetPrimalIS(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoalmmgetdualis_ TAOALMMGETDUALIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoalmmgetdualis_ taoalmmgetdualis
#endif
PETSC_EXTERN void taoalmmgetdualis_(Tao *a, IS *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = TaoALMMGetDualIS(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
