#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutcreate_ PETSCLAYOUTCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutcreate_ petsclayoutcreate
#endif
PETSC_EXTERN void petsclayoutcreate_(MPI_Fint *a, PetscLayout *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscLayoutCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutcreatefromsizes_ PETSCLAYOUTCREATEFROMSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutcreatefromsizes_ petsclayoutcreatefromsizes
#endif
PETSC_EXTERN void petsclayoutcreatefromsizes_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscLayout *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscLayoutCreateFromSizes(MPI_Comm_f2c(*(a)), *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutdestroy_ PETSCLAYOUTDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutdestroy_ petsclayoutdestroy
#endif
PETSC_EXTERN void petsclayoutdestroy_(PetscLayout *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscLayoutDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutcreatefromranges_ PETSCLAYOUTCREATEFROMRANGES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutcreatefromranges_ petsclayoutcreatefromranges
#endif
PETSC_EXTERN void petsclayoutcreatefromranges_(MPI_Fint *a, const PetscInt b[], PetscCopyMode *c, PetscInt *d, PetscLayout *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscLayoutCreateFromRanges(MPI_Comm_f2c(*(a)), b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutsetup_ PETSCLAYOUTSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutsetup_ petsclayoutsetup
#endif
PETSC_EXTERN void petsclayoutsetup_(PetscLayout *a, PetscErrorCode *ierr)
{
  *ierr = PetscLayoutSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutduplicate_ PETSCLAYOUTDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutduplicate_ petsclayoutduplicate
#endif
PETSC_EXTERN void petsclayoutduplicate_(PetscLayout *a, PetscLayout *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscLayoutDuplicate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutreference_ PETSCLAYOUTREFERENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutreference_ petsclayoutreference
#endif
PETSC_EXTERN void petsclayoutreference_(PetscLayout *a, PetscLayout *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscLayoutReference(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutsetislocaltoglobalmapping_ PETSCLAYOUTSETISLOCALTOGLOBALMAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutsetislocaltoglobalmapping_ petsclayoutsetislocaltoglobalmapping
#endif
PETSC_EXTERN void petsclayoutsetislocaltoglobalmapping_(PetscLayout *a, ISLocalToGlobalMapping *b, PetscErrorCode *ierr)
{
  *ierr = PetscLayoutSetISLocalToGlobalMapping(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutsetlocalsize_ PETSCLAYOUTSETLOCALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutsetlocalsize_ petsclayoutsetlocalsize
#endif
PETSC_EXTERN void petsclayoutsetlocalsize_(PetscLayout *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscLayoutSetLocalSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutgetlocalsize_ PETSCLAYOUTGETLOCALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutgetlocalsize_ petsclayoutgetlocalsize
#endif
PETSC_EXTERN void petsclayoutgetlocalsize_(PetscLayout *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscLayoutGetLocalSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutsetsize_ PETSCLAYOUTSETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutsetsize_ petsclayoutsetsize
#endif
PETSC_EXTERN void petsclayoutsetsize_(PetscLayout *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscLayoutSetSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutgetsize_ PETSCLAYOUTGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutgetsize_ petsclayoutgetsize
#endif
PETSC_EXTERN void petsclayoutgetsize_(PetscLayout *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscLayoutGetSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutsetblocksize_ PETSCLAYOUTSETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutsetblocksize_ petsclayoutsetblocksize
#endif
PETSC_EXTERN void petsclayoutsetblocksize_(PetscLayout *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscLayoutSetBlockSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutgetblocksize_ PETSCLAYOUTGETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutgetblocksize_ petsclayoutgetblocksize
#endif
PETSC_EXTERN void petsclayoutgetblocksize_(PetscLayout *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscLayoutGetBlockSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutgetrange_ PETSCLAYOUTGETRANGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutgetrange_ petsclayoutgetrange
#endif
PETSC_EXTERN void petsclayoutgetrange_(PetscLayout *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscLayoutGetRange(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutcompare_ PETSCLAYOUTCOMPARE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutcompare_ petsclayoutcompare
#endif
PETSC_EXTERN void petsclayoutcompare_(PetscLayout *a, PetscLayout *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscLayoutCompare(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutfindowner_ PETSCLAYOUTFINDOWNER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutfindowner_ petsclayoutfindowner
#endif
PETSC_EXTERN void petsclayoutfindowner_(PetscLayout *a, PetscInt *b, PetscMPIInt *c, PetscErrorCode *ierr)
{
  *ierr = PetscLayoutFindOwner(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclayoutfindownerindex_ PETSCLAYOUTFINDOWNERINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclayoutfindownerindex_ petsclayoutfindownerindex
#endif
PETSC_EXTERN void petsclayoutfindownerindex_(PetscLayout *a, PetscInt *b, PetscMPIInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscLayoutFindOwnerIndex(*a, *b, c, d);
  if (*ierr) return;
}
