#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscmatlab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmatlabenginecreate_ PETSCMATLABENGINECREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmatlabenginecreate_ petscmatlabenginecreate
#endif
PETSC_EXTERN void petscmatlabenginecreate_(MPI_Fint *a, char b[], PetscMatlabEngine *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(c);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscMatlabEngineCreate(MPI_Comm_f2c(*(a)), c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscmatlab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmatlabenginedestroy_ PETSCMATLABENGINEDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmatlabenginedestroy_ petscmatlabenginedestroy
#endif
PETSC_EXTERN void petscmatlabenginedestroy_(PetscMatlabEngine *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscMatlabEngineDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscmatlab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmatlabenginegetoutput_ PETSCMATLABENGINEGETOUTPUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmatlabenginegetoutput_ petscmatlabenginegetoutput
#endif
PETSC_EXTERN void petscmatlabenginegetoutput_(PetscMatlabEngine *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscMatlabEngineGetOutput(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscmatlab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmatlabengineput_ PETSCMATLABENGINEPUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmatlabengineput_ petscmatlabengineput
#endif
PETSC_EXTERN void petscmatlabengineput_(PetscMatlabEngine *a, PetscObject *b, PetscErrorCode *ierr)
{
  *ierr = PetscMatlabEnginePut(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscmatlab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmatlabengineget_ PETSCMATLABENGINEGET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmatlabengineget_ petscmatlabengineget
#endif
PETSC_EXTERN void petscmatlabengineget_(PetscMatlabEngine *a, PetscObject *b, PetscErrorCode *ierr)
{
  *ierr = PetscMatlabEngineGet(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscmatlab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmatlabengineputarray_ PETSCMATLABENGINEPUTARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmatlabengineputarray_ petscmatlabengineputarray
#endif
PETSC_EXTERN void petscmatlabengineputarray_(PetscMatlabEngine *a, int *b, int *c, const PetscScalar d[], char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  CHKFORTRANNULLSCALAR(d);
  *ierr = PetscMatlabEnginePutArray(*a, *b, *c, d, c_e);
  if (*ierr) return;
  FREECHAR(e, c_e);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscmatlab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmatlabenginegetarray_ PETSCMATLABENGINEGETARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmatlabenginegetarray_ petscmatlabenginegetarray
#endif
PETSC_EXTERN void petscmatlabenginegetarray_(PetscMatlabEngine *a, int *b, int *c, PetscScalar d[], char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  CHKFORTRANNULLSCALAR(d);
  *ierr = PetscMatlabEngineGetArray(*a, *b, *c, d, c_e);
  if (*ierr) return;
  FREECHAR(e, c_e);
}
