#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tspseudocomputetimestep_ TSPSEUDOCOMPUTETIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tspseudocomputetimestep_ tspseudocomputetimestep
#endif
PETSC_EXTERN void tspseudocomputetimestep_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TSPseudoComputeTimeStep(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tspseudoverifytimestepdefault_ TSPSEUDOVERIFYTIMESTEPDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tspseudoverifytimestepdefault_ tspseudoverifytimestepdefault
#endif
PETSC_EXTERN void tspseudoverifytimestepdefault_(TS *a, Vec *b, void *c, PetscReal *d, PetscBool *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLBOOL(e);
  *ierr = TSPseudoVerifyTimeStepDefault(*a, *b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tspseudoverifytimestep_ TSPSEUDOVERIFYTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tspseudoverifytimestep_ tspseudoverifytimestep
#endif
PETSC_EXTERN void tspseudoverifytimestep_(TS *a, Vec *b, PetscReal *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLBOOL(d);
  *ierr = TSPseudoVerifyTimeStep(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tspseudosettimestepincrement_ TSPSEUDOSETTIMESTEPINCREMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tspseudosettimestepincrement_ tspseudosettimestepincrement
#endif
PETSC_EXTERN void tspseudosettimestepincrement_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TSPseudoSetTimeStepIncrement(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tspseudosetmaxtimestep_ TSPSEUDOSETMAXTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tspseudosetmaxtimestep_ tspseudosetmaxtimestep
#endif
PETSC_EXTERN void tspseudosetmaxtimestep_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TSPseudoSetMaxTimeStep(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tspseudoincrementdtfrominitialdt_ TSPSEUDOINCREMENTDTFROMINITIALDT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tspseudoincrementdtfrominitialdt_ tspseudoincrementdtfrominitialdt
#endif
PETSC_EXTERN void tspseudoincrementdtfrominitialdt_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSPseudoIncrementDtFromInitialDt(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tspseudotimestepdefault_ TSPSEUDOTIMESTEPDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tspseudotimestepdefault_ tspseudotimestepdefault
#endif
PETSC_EXTERN void tspseudotimestepdefault_(TS *a, PetscReal *b, void *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TSPseudoTimeStepDefault(*a, b, c);
  if (*ierr) return;
}
