#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfecreatevector_ PETSCFECREATEVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfecreatevector_ petscfecreatevector
#endif
PETSC_EXTERN void petscfecreatevector_(PetscFE *a, PetscInt *b, PetscBool *c, PetscBool *d, PetscFE *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscFECreateVector(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d ? PETSC_TRUE : PETSC_FALSE, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
