#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdfischer_ MATDFISCHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdfischer_ matdfischer
#endif
PETSC_EXTERN void matdfischer_(Mat *a, Vec *b, Vec *c, Vec *d, Vec *e, Vec *f, Vec *g, Vec *h, Vec *i, PetscErrorCode *ierr)
{
  *ierr = MatDFischer(*a, *b, *c, *d, *e, *f, *g, *h, *i);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdsfischer_ MATDSFISCHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdsfischer_ matdsfischer
#endif
PETSC_EXTERN void matdsfischer_(Mat *a, Vec *b, Vec *c, Vec *d, Vec *e, PetscReal *f, Vec *g, Vec *h, Vec *i, Vec *j, Vec *k, PetscErrorCode *ierr)
{
  *ierr = MatDSFischer(*a, *b, *c, *d, *e, *f, *g, *h, *i, *j, *k);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosoftthreshold_ TAOSOFTTHRESHOLD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosoftthreshold_ taosoftthreshold
#endif
PETSC_EXTERN void taosoftthreshold_(Vec *a, PetscReal *b, PetscReal *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = TaoSoftThreshold(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecfischer_ VECFISCHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecfischer_ vecfischer
#endif
PETSC_EXTERN void vecfischer_(Vec *a, Vec *b, Vec *c, Vec *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = VecFischer(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsfischer_ VECSFISCHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsfischer_ vecsfischer
#endif
PETSC_EXTERN void vecsfischer_(Vec *a, Vec *b, Vec *c, Vec *d, PetscReal *e, Vec *f, PetscErrorCode *ierr)
{
  *ierr = VecSFischer(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
