#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdllibraryprintpath_ PETSCDLLIBRARYPRINTPATH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdllibraryprintpath_ petscdllibraryprintpath
#endif
PETSC_EXTERN void petscdllibraryprintpath_(PetscDLLibrary *a, PetscErrorCode *ierr)
{
  *ierr = PetscDLLibraryPrintPath(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdllibraryretrieve_ PETSCDLLIBRARYRETRIEVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdllibraryretrieve_ petscdllibraryretrieve
#endif
PETSC_EXTERN void petscdllibraryretrieve_(MPI_Fint *a, char b[], char c[], PetscBool *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscDLLibraryRetrieve(MPI_Comm_f2c(*(a)), c_b, c, l_c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdllibraryopen_ PETSCDLLIBRARYOPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdllibraryopen_ petscdllibraryopen
#endif
PETSC_EXTERN void petscdllibraryopen_(MPI_Fint *a, char b[], PetscDLLibrary *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDLLibraryOpen(MPI_Comm_f2c(*(a)), c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdllibraryappend_ PETSCDLLIBRARYAPPEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdllibraryappend_ petscdllibraryappend
#endif
PETSC_EXTERN void petscdllibraryappend_(MPI_Fint *a, PetscDLLibrary *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDLLibraryAppend(MPI_Comm_f2c(*(a)), b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdllibraryprepend_ PETSCDLLIBRARYPREPEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdllibraryprepend_ petscdllibraryprepend
#endif
PETSC_EXTERN void petscdllibraryprepend_(MPI_Fint *a, PetscDLLibrary *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDLLibraryPrepend(MPI_Comm_f2c(*(a)), b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdllibraryclose_ PETSCDLLIBRARYCLOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdllibraryclose_ petscdllibraryclose
#endif
PETSC_EXTERN void petscdllibraryclose_(PetscDLLibrary *a, PetscErrorCode *ierr)
{
  *ierr = PetscDLLibraryClose(*a);
  if (*ierr) return;
}
