#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagvecsplittodmda_ DMSTAGVECSPLITTODMDA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagvecsplittodmda_ dmstagvecsplittodmda
#endif
PETSC_EXTERN void dmstagvecsplittodmda_(DM *a, Vec *b, DMStagStencilLocation *c, PetscInt *d, DM *e, Vec *f, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = DMStagVecSplitToDMDA(*a, *b, *c, *d, e, f);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
