# adb reverse

> Reverse socket connections from a connected Android device or emulator.
> More information: <https://developer.android.com/tools/adb>.

- List all reverse socket connections from emulators and devices:

`adb reverse --list`

- Reverse a TCP port from the only connected emulator or device to localhost:

`adb reverse tcp:{{remote_port}} tcp:{{local_port}}`

- Reverse a TCP port from a specific emulator or device (by device ID / [s]erial number) to localhost:

`adb -s {{device_ID}} reverse tcp:{{remote_port}} tcp:{{local_port}}`

- Remove a reverse socket connection from an emulator or device:

`adb reverse --remove tcp:{{remote_port}}`

- Remove all reverse socket connections from all emulators and devices:

`adb reverse --remove-all`
