# lzip

> `gzip` 또는 `bzip2`와 유사한 사용자 인터페이스를 가진 무손실 데이터 압축기.
> Lzip은 "Lempel-Ziv-Markovchain-Algorithm" (LZMA) 스트림 형식의 단순화된 형태를 사용하며 상호 운용성을 극대화하고 안전성을 최적화하기 위해 3단계 무결성 검사를 제공합니다.
> 더 많은 정보: <https://www.nongnu.org/lzip/manual/lzip_manual.html#Invoking-lzip>.

- 파일을 압축하여 원본 파일을 대체:

`lzip {{경로/대상/파일}}`

- 파일을 압축하면서 원본 파일 유지:

`lzip -k {{경로/대상/파일}}`

- 가장 높은 압축률로 파일 압축 (레벨=9):

`lzip -k {{경로/대상/파일}} --best`

- 가장 빠른 속도로 파일 압축 (레벨=0):

`lzip -k {{경로/대상/파일}} --fast`

- 압축 파일의 무결성 테스트:

`lzip --test {{경로/대상/아카이브.lz}}`

- 파일을 압축 해제하여 원본 파일로 대체:

`lzip -d {{경로/대상/아카이브.lz}}`

- 파일을 압축 해제하면서 압축본 유지:

`lzip -d -k {{경로/대상/아카이브.lz}}`

- 아카이브 내 파일 목록 및 압축 통계 표시:

`lzip --list {{경로/대상/아카이브.lz}}`
